import json, re, inspect

try:
	regexlist = open("code_protect.txt","r")
	temp = regexlist.read()
	coderegex = temp.split("\n")
	codeflag = True
except:
	codeflag = False
	
try:
	regexlist = open("in_protect.txt","r")
	temp = regexlist.read()
	inregex = temp.split("\n")
	inflag = True
except:
	inflag = False

try:
	regexlist = open("out_protect.txt","r")
	temp = regexlist.read()
	outregex = temp.split("\n")
	outflag = True
except:
	outflag = False

def protect(lambdaguard):
	def guard(event, context):
		
		if codeflag==True:
			code = inspect.getsource(lambdaguard)
			for j in coderegex:
				m = re.search(j,code,re.IGNORECASE)
				if m:
					print("Code Rule violation for ",j)
					return("Security Violation...")
		
		if inflag==True:
			eventstream = json.dumps(event)
			for j in inregex:
				m = re.search(j,eventstream,re.IGNORECASE)
				if m:
					print("Input Rule violation for ",j)
					return("Security Violation...")
		
		filter=lambdaguard(event, context)
		
		if outflag==True:
			for k in outregex:
				m = re.search(k,filter,re.IGNORECASE)
				if m:
					print("Output Rule violation for ",k)
					return("Security Violation...")
		return filter
	return guard