/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.resolver.ResolverTuple;

public class Resolver {
    public static final Pattern BOOL = Pattern.compile("^(?:yes|Yes|YES|no|No|NO|true|True|TRUE|false|False|FALSE|on|On|ON|off|Off|OFF)$");
    public static final Pattern FLOAT = Pattern.compile("^(?:[-+]?(?:[0-9][0-9_]*)\\.[0-9_]*(?:[eE][-+][0-9]+)?|[-+]?(?:[0-9][0-9_]*)?\\.[0-9_]+(?:[eE][-+][0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
    public static final Pattern INT = Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?[0-9])+)$");
    public static final Pattern MERGE = Pattern.compile("^(?:<<)$");
    public static final Pattern NULL = Pattern.compile("^(?:~|null|Null|NULL| )$");
    public static final Pattern EMPTY = Pattern.compile("^$");
    public static final Pattern TIMESTAMP = Pattern.compile("^(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9][0-9][0-9][0-9]-[0-9][0-9]?-[0-9][0-9]?(?:[Tt]|[ \t]+)[0-9][0-9]?:[0-9][0-9]:[0-9][0-9](?:\\.[0-9]*)?(?:[ \t]*(?:Z|[-+][0-9][0-9]?(?::[0-9][0-9])?))?)$");
    public static final Pattern VALUE = Pattern.compile("^(?:=)$");
    public static final Pattern YAML = Pattern.compile("^(?:!|&|\\*)$");
    protected Map<Character, List<ResolverTuple>> yamlImplicitResolvers = new HashMap<Character, List<ResolverTuple>>();

    public Resolver(boolean bl) {
        if (bl) {
            this.addImplicitResolvers();
        }
    }

    protected void addImplicitResolvers() {
        this.addImplicitResolver("tag:yaml.org,2002:bool", BOOL, "yYnNtTfFoO");
        this.addImplicitResolver("tag:yaml.org,2002:float", FLOAT, "-+0123456789.");
        this.addImplicitResolver("tag:yaml.org,2002:int", INT, "-+0123456789");
        this.addImplicitResolver("tag:yaml.org,2002:merge", MERGE, "<");
        this.addImplicitResolver("tag:yaml.org,2002:null", NULL, "~nN\u0000");
        this.addImplicitResolver("tag:yaml.org,2002:null", EMPTY, null);
        this.addImplicitResolver("tag:yaml.org,2002:timestamp", TIMESTAMP, "0123456789");
        this.addImplicitResolver("tag:yaml.org,2002:value", VALUE, "=");
        this.addImplicitResolver("tag:yaml.org,2002:yaml", YAML, "!&*");
    }

    public Resolver() {
        this(true);
    }

    public void addImplicitResolver(String string, Pattern pattern, String string2) {
        if (string2 == null) {
            List<ResolverTuple> list = this.yamlImplicitResolvers.get(null);
            if (list == null) {
                list = new ArrayList<ResolverTuple>();
                this.yamlImplicitResolvers.put(null, list);
            }
            list.add(new ResolverTuple(string, pattern));
        } else {
            char[] cArray = string2.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                List<ResolverTuple> list;
                Character c = new Character(cArray[i]);
                if (c.charValue() == '\u0000') {
                    c = null;
                }
                if ((list = this.yamlImplicitResolvers.get(c)) == null) {
                    list = new ArrayList<ResolverTuple>();
                    this.yamlImplicitResolvers.put(c, list);
                }
                list.add(new ResolverTuple(string, pattern));
            }
        }
    }

    public String resolve(NodeId nodeId, String string, boolean bl) {
        if (nodeId == NodeId.scalar && bl) {
            Pattern pattern;
            String string2;
            List<ResolverTuple> list = null;
            list = "".equals(string) ? this.yamlImplicitResolvers.get(Character.valueOf('\u0000')) : this.yamlImplicitResolvers.get(Character.valueOf(string.charAt(0)));
            if (list != null) {
                for (ResolverTuple resolverTuple : list) {
                    string2 = resolverTuple.getTag();
                    pattern = resolverTuple.getRegexp();
                    if (!pattern.matcher(string).matches()) continue;
                    return string2;
                }
            }
            if (this.yamlImplicitResolvers.containsKey(null)) {
                for (ResolverTuple resolverTuple : this.yamlImplicitResolvers.get(null)) {
                    string2 = resolverTuple.getTag();
                    pattern = resolverTuple.getRegexp();
                    if (!pattern.matcher(string).matches()) continue;
                    return string2;
                }
            }
        }
        switch (nodeId) {
            case scalar: {
                return "tag:yaml.org,2002:str";
            }
            case sequence: {
                return "tag:yaml.org,2002:seq";
            }
        }
        return "tag:yaml.org,2002:map";
    }
}

