/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.EmitterException;
import org.yaml.snakeyaml.emitter.EmitterState;
import org.yaml.snakeyaml.emitter.ScalarAnalysis;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionEndEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.util.ArrayStack;

public final class Emitter {
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    public static final int MIN_INDENT = 1;
    public static final int MAX_INDENT = 10;
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    private final Writer stream;
    private final ArrayStack<EmitterState> states;
    private EmitterState state;
    private final Queue<Event> events;
    private Event event;
    private final ArrayStack<Integer> indents;
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private Boolean canonical;
    private boolean allowUnicode;
    private int bestIndent;
    private int bestWidth;
    private String bestLineBreak;
    private Map<String, String> tagPrefixes;
    private String preparedAnchor;
    private String preparedTag;
    private ScalarAnalysis analysis;
    private Character style;
    private static final Pattern HANDLE_FORMAT;
    private static final Pattern ANCHOR_FORMAT;

    public Emitter(Writer writer, DumperOptions dumperOptions) {
        this.stream = writer;
        this.states = new ArrayStack(100);
        this.state = new ExpectStreamStart();
        this.events = new ArrayBlockingQueue<Event>(100);
        this.event = null;
        this.indents = new ArrayStack(10);
        this.indent = null;
        this.flowLevel = 0;
        this.mappingContext = false;
        this.simpleKeyContext = false;
        this.column = 0;
        this.whitespace = true;
        this.indention = true;
        this.openEnded = false;
        this.canonical = dumperOptions.isCanonical();
        this.allowUnicode = dumperOptions.isAllowUnicode();
        this.bestIndent = 2;
        if (dumperOptions.getIndent() > 1 && dumperOptions.getIndent() < 10) {
            this.bestIndent = dumperOptions.getIndent();
        }
        this.bestWidth = 80;
        if (dumperOptions.getWidth() > this.bestIndent * 2) {
            this.bestWidth = dumperOptions.getWidth();
        }
        this.bestLineBreak = dumperOptions.getLineBreak().getString();
        this.tagPrefixes = new LinkedHashMap<String, String>();
        this.preparedAnchor = null;
        this.preparedTag = null;
        this.analysis = null;
        this.style = null;
    }

    public void emit(Event event) throws IOException {
        this.events.add(event);
        while (!this.needMoreEvents()) {
            this.event = this.events.poll();
            this.state.expect();
            this.event = null;
        }
    }

    private boolean needMoreEvents() {
        if (this.events.isEmpty()) {
            return true;
        }
        Event event = this.events.peek();
        if (event instanceof DocumentStartEvent) {
            return this.needEvents(1);
        }
        if (event instanceof SequenceStartEvent) {
            return this.needEvents(2);
        }
        if (event instanceof MappingStartEvent) {
            return this.needEvents(3);
        }
        return false;
    }

    private boolean needEvents(int n) {
        int n2 = 0;
        Iterator iterator = this.events.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Event event = (Event)iterator.next();
            if (event instanceof DocumentStartEvent || event instanceof CollectionStartEvent) {
                ++n2;
            } else if (event instanceof DocumentEndEvent || event instanceof CollectionEndEvent) {
                --n2;
            } else if (event instanceof StreamEndEvent) {
                n2 = -1;
            }
            if (n2 >= 0) continue;
            return false;
        }
        return this.events.size() < n + 1;
    }

    private void increaseIndent(boolean bl, boolean bl2) {
        this.indents.push(this.indent);
        if (this.indent == null) {
            this.indent = bl ? Integer.valueOf(this.bestIndent) : Integer.valueOf(0);
        } else if (!bl2) {
            Emitter emitter = this;
            emitter.indent = emitter.indent + this.bestIndent;
        }
    }

    private void expectNode(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        this.rootContext = bl;
        this.mappingContext = bl3;
        this.simpleKeyContext = bl4;
        if (this.event instanceof AliasEvent) {
            this.expectAlias();
        } else if (this.event instanceof ScalarEvent || this.event instanceof CollectionStartEvent) {
            this.processAnchor("&");
            this.processTag();
            if (this.event instanceof ScalarEvent) {
                this.expectScalar();
            } else if (this.event instanceof SequenceStartEvent) {
                if (this.flowLevel != 0 || this.canonical.booleanValue() || ((SequenceStartEvent)this.event).getFlowStyle().booleanValue() || this.checkEmptySequence()) {
                    this.expectFlowSequence();
                } else {
                    this.expectBlockSequence();
                }
            } else if (this.flowLevel != 0 || this.canonical.booleanValue() || ((MappingStartEvent)this.event).getFlowStyle().booleanValue() || this.checkEmptyMapping()) {
                this.expectFlowMapping();
            } else {
                this.expectBlockMapping();
            }
        } else {
            throw new EmitterException("expected NodeEvent, but got " + this.event);
        }
    }

    private void expectAlias() throws IOException {
        if (((NodeEvent)this.event).getAnchor() == null) {
            throw new EmitterException("anchor is not specified for alias");
        }
        this.processAnchor("*");
        this.state = this.states.pop();
    }

    private void expectScalar() throws IOException {
        this.increaseIndent(true, false);
        this.processScalar();
        this.indent = this.indents.pop();
        this.state = this.states.pop();
    }

    private void expectFlowSequence() throws IOException {
        this.writeIndicator("[", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        this.state = new ExpectFirstFlowSequenceItem();
    }

    private void expectFlowMapping() throws IOException {
        this.writeIndicator("{", true, true, false);
        ++this.flowLevel;
        this.increaseIndent(true, false);
        this.state = new ExpectFirstFlowMappingKey();
    }

    private void expectBlockSequence() throws IOException {
        boolean bl = this.mappingContext && !this.indention;
        this.increaseIndent(false, bl);
        this.state = new ExpectFirstBlockSequenceItem();
    }

    private void expectBlockMapping() throws IOException {
        this.increaseIndent(false, false);
        this.state = new ExpectFirstBlockMappingKey();
    }

    private boolean checkEmptySequence() {
        return this.event instanceof SequenceStartEvent && !this.events.isEmpty() && this.events.peek() instanceof SequenceEndEvent;
    }

    private boolean checkEmptyMapping() {
        return this.event instanceof MappingStartEvent && !this.events.isEmpty() && this.events.peek() instanceof MappingEndEvent;
    }

    private boolean checkEmptyDocument() {
        if (!(this.event instanceof DocumentStartEvent) || this.events.isEmpty()) {
            return false;
        }
        Event event = this.events.peek();
        if (event instanceof ScalarEvent) {
            ScalarEvent scalarEvent = (ScalarEvent)event;
            return scalarEvent.getAnchor() == null && scalarEvent.getTag() == null && scalarEvent.getImplicit() != null && scalarEvent.getValue() == "";
        }
        return false;
    }

    private boolean checkSimpleKey() {
        int n = 0;
        if (this.event instanceof NodeEvent && ((NodeEvent)this.event).getAnchor() != null) {
            if (this.preparedAnchor == null) {
                this.preparedAnchor = Emitter.prepareAnchor(((NodeEvent)this.event).getAnchor());
            }
            n += this.preparedAnchor.length();
        }
        String string = null;
        if (this.event instanceof ScalarEvent) {
            string = ((ScalarEvent)this.event).getTag();
        } else if (this.event instanceof CollectionStartEvent) {
            string = ((CollectionStartEvent)this.event).getTag();
        }
        if (string != null) {
            if (this.preparedTag == null) {
                this.preparedTag = this.prepareTag(string);
            }
            n += this.preparedTag.length();
        }
        if (this.event instanceof ScalarEvent) {
            if (this.analysis == null) {
                this.analysis = this.analyzeScalar(((ScalarEvent)this.event).getValue());
            }
            n += this.analysis.scalar.length();
        }
        return n < 128 && (this.event instanceof AliasEvent || this.event instanceof ScalarEvent && !this.analysis.empty && !this.analysis.multiline || this.checkEmptySequence() || this.checkEmptyMapping());
    }

    private void processAnchor(String string) throws IOException {
        NodeEvent nodeEvent = (NodeEvent)this.event;
        if (nodeEvent.getAnchor() == null) {
            this.preparedAnchor = null;
            return;
        }
        if (this.preparedAnchor == null) {
            this.preparedAnchor = Emitter.prepareAnchor(nodeEvent.getAnchor());
        }
        if (this.preparedAnchor != null && !"".equals(this.preparedAnchor)) {
            this.writeIndicator(string + this.preparedAnchor, true, false, false);
        }
        this.preparedAnchor = null;
    }

    private void processTag() throws IOException {
        String string = null;
        if (this.event instanceof ScalarEvent) {
            ScalarEvent scalarEvent = (ScalarEvent)this.event;
            string = scalarEvent.getTag();
            if (this.style == null) {
                this.style = this.chooseScalarStyle();
            }
            if ((!this.canonical.booleanValue() || string == null) && (this.style == null && scalarEvent.getImplicit().isFirst() || this.style != null && scalarEvent.getImplicit().isSecond())) {
                this.preparedTag = null;
                return;
            }
            if (scalarEvent.getImplicit().isFirst() && string == null) {
                string = "!";
                this.preparedTag = null;
            }
        } else {
            CollectionStartEvent collectionStartEvent = (CollectionStartEvent)this.event;
            string = collectionStartEvent.getTag();
            if ((!this.canonical.booleanValue() || string == null) && collectionStartEvent.getImplicit()) {
                this.preparedTag = null;
                return;
            }
        }
        if (string == null) {
            throw new EmitterException("tag is not specified");
        }
        if (this.preparedTag == null) {
            this.preparedTag = this.prepareTag(string);
        }
        if (this.preparedTag != null && !"".equals(this.preparedTag)) {
            this.writeIndicator(this.preparedTag, true, false, false);
        }
        this.preparedTag = null;
    }

    private Character chooseScalarStyle() {
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (scalarEvent.getStyle() != null && scalarEvent.getStyle().charValue() == '\"' || this.canonical.booleanValue()) {
            return Character.valueOf('\"');
        }
        if (scalarEvent.getStyle() == null && scalarEvent.getImplicit().isFirst() && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
            return null;
        }
        if (scalarEvent.getStyle() != null && (scalarEvent.getStyle().charValue() == '|' || scalarEvent.getStyle().charValue() == '>') && this.flowLevel == 0 && !this.simpleKeyContext && this.analysis.allowBlock) {
            return scalarEvent.getStyle();
        }
        if (!(scalarEvent.getStyle() != null && scalarEvent.getStyle().charValue() != '\'' || !this.analysis.allowSingleQuoted || this.simpleKeyContext && this.analysis.multiline)) {
            return Character.valueOf('\'');
        }
        return Character.valueOf('\"');
    }

    private void processScalar() throws IOException {
        boolean bl;
        ScalarEvent scalarEvent = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(scalarEvent.getValue());
        }
        if (this.style == null) {
            this.style = this.chooseScalarStyle();
        }
        boolean bl2 = bl = !this.simpleKeyContext;
        if (this.style == null) {
            this.writePlain(this.analysis.scalar, bl);
        } else {
            switch (this.style.charValue()) {
                case '\"': {
                    this.writeDoubleQuoted(this.analysis.scalar, bl);
                    break;
                }
                case '\'': {
                    this.writeSingleQuoted(this.analysis.scalar, bl);
                    break;
                }
                case '>': {
                    this.writeFolded(this.analysis.scalar);
                    break;
                }
                case '|': {
                    this.writeLiteral(this.analysis.scalar);
                }
            }
        }
        this.analysis = null;
        this.style = null;
    }

    private String prepareVersion(Integer[] integerArray) {
        Integer n = integerArray[0];
        Integer n2 = integerArray[1];
        if (n != 1) {
            throw new EmitterException("unsupported YAML version: " + integerArray[0] + "." + integerArray[1]);
        }
        return n.toString() + "." + n2.toString();
    }

    private String prepareTagHandle(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("tag handle must not be empty");
        }
        if (string.charAt(0) != '!' || string.charAt(string.length() - 1) != '!') {
            throw new EmitterException("tag handle must start and end with '!': " + string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid character in the tag handle: " + string);
        }
        return string;
    }

    private String prepareTagPrefix(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        if (string.charAt(0) == '!') {
            n2 = 1;
        }
        while (n2 < string.length()) {
            ++n2;
        }
        if (n < n2) {
            stringBuffer.append(string.substring(n, n2));
        }
        return stringBuffer.toString();
    }

    private String prepareTag(String string) {
        int n;
        if (string == null || "".equals(string)) {
            throw new EmitterException("tag must not be empty");
        }
        if ("!".equals(string)) {
            return string;
        }
        String string2 = null;
        String string3 = string;
        for (String string4 : this.tagPrefixes.keySet()) {
            if (!string.startsWith(string4) || !"!".equals(string4) && string4.length() >= string.length()) continue;
            string2 = this.tagPrefixes.get(string4);
            string3 = string.substring(string4.length());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (n = 0; n < string3.length(); ++n) {
        }
        if (n2 < n) {
            stringBuffer.append(string3.substring(n2, n));
        }
        String string5 = stringBuffer.toString();
        if (string2 != null) {
            return string2 + string5;
        }
        return "!<" + string5 + ">";
    }

    static String prepareAnchor(String string) {
        if (string == null || "".equals(string)) {
            throw new EmitterException("anchor must not be empty");
        }
        if (!ANCHOR_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid character in the anchor: " + string);
        }
        return string;
    }

    private ScalarAnalysis analyzeScalar(String string) {
        boolean bl;
        if (string == null || "".equals(string)) {
            return new ScalarAnalysis(string, true, false, false, true, true, true, false);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        if (string.startsWith("---") || string.startsWith("...")) {
            bl2 = true;
            bl3 = true;
        }
        boolean bl12 = true;
        boolean bl13 = string.length() == 1 || "\u0000 \t\r\n\u0085\u2029\u2029".indexOf(string.charAt(1)) != -1;
        boolean bl14 = false;
        boolean bl15 = false;
        int n = 0;
        while (n < string.length()) {
            char bl16 = string.charAt(n);
            if (n == 0) {
                if ("#,[]{}&*!|>'\"%@`".indexOf(bl16) != -1) {
                    bl3 = true;
                    bl2 = true;
                }
                if (bl16 == '?' || bl16 == ':') {
                    bl3 = true;
                    if (bl13) {
                        bl2 = true;
                    }
                }
                if (bl16 == '-' && bl13) {
                    bl3 = true;
                    bl2 = true;
                }
            } else {
                if (",?[]{}".indexOf(bl16) != -1) {
                    bl3 = true;
                }
                if (bl16 == ':') {
                    bl3 = true;
                    if (bl13) {
                        bl2 = true;
                    }
                }
                if (bl16 == '#' && bl12) {
                    bl3 = true;
                    bl2 = true;
                }
            }
            if (bl16 == '\n' || bl16 == '\u0085' || bl16 == '\u2028' || bl16 == '\u2029') {
                bl4 = true;
            }
            if (bl16 != '\n' && (' ' > bl16 || bl16 > '~')) {
                if ((bl16 == '\u0085' || '\u00a0' <= bl16 && bl16 <= '\ud7ff' || '\ue000' <= bl16 && bl16 <= '\ufffd') && bl16 != '\ufeff') {
                    if (!this.allowUnicode) {
                        bl5 = true;
                    }
                } else {
                    bl5 = true;
                }
            }
            if (bl16 == ' ') {
                if (n == 0) {
                    bl6 = true;
                }
                if (n == string.length() - 1) {
                    bl8 = true;
                }
                if (bl15) {
                    bl10 = true;
                }
                bl14 = true;
                bl15 = false;
            } else if ("\n\u0085\u2028\u2029".indexOf(bl16) != -1) {
                if (n == 0) {
                    bl7 = true;
                }
                if (n == string.length() - 1) {
                    bl9 = true;
                }
                if (bl14) {
                    bl11 = true;
                }
                bl14 = false;
                bl15 = true;
            } else {
                bl14 = false;
                bl15 = false;
            }
            bl12 = "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(bl16) != -1;
            bl13 = ++n + 1 >= string.length() || "\u0000 \t\r\n\u0085\u2028\u2029".indexOf(string.charAt(n + 1)) != -1;
        }
        boolean bl17 = true;
        boolean bl18 = true;
        boolean bl19 = true;
        boolean bl20 = true;
        boolean bl21 = true;
        if (bl6 || bl7 || bl8 || bl9) {
            bl18 = false;
            boolean bl22 = false;
        }
        if (bl8) {
            bl21 = false;
        }
        if (bl10) {
            bl19 = false;
            bl18 = false;
            boolean bl23 = false;
        }
        if (bl11 || bl5) {
            bl21 = false;
            bl19 = false;
            bl18 = false;
            boolean bl24 = false;
        }
        if (bl4) {
            bl18 = false;
            boolean bl25 = false;
        }
        if (bl3) {
            bl = false;
        }
        if (bl2) {
            bl18 = false;
        }
        return new ScalarAnalysis(string, false, bl4, bl, bl18, bl19, bl20, bl21);
    }

    void flushStream() throws IOException {
        this.stream.flush();
    }

    void writeStreamStart() {
    }

    void writeStreamEnd() throws IOException {
        this.flushStream();
    }

    void writeIndicator(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string2 = null;
        string2 = this.whitespace || !bl ? string : " " + string;
        this.whitespace = bl2;
        this.indention = this.indention && bl3;
        this.column += string2.length();
        this.openEnded = false;
        this.stream.write(string2);
    }

    void writeIndent() throws IOException {
        int n = this.indent != null ? this.indent : 0;
        if (!this.indention || this.column > n || this.column == n && !this.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.column < n) {
            this.whitespace = true;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n - this.column; ++i) {
                stringBuffer.append(" ");
            }
            this.column = n;
            this.stream.write(stringBuffer.toString());
        }
    }

    private void writeLineBreak(String string) throws IOException {
        if (string == null) {
            string = this.bestLineBreak;
        }
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        this.stream.write(string);
    }

    void writeVersionDirective(String string) throws IOException {
        this.stream.write("%YAML " + string);
        this.writeLineBreak(null);
    }

    void writeTagDirective(String string, String string2) throws IOException {
        this.stream.write("%TAG " + string + " " + string2);
        this.writeLineBreak(null);
    }

    private void writeSingleQuoted(String string, boolean bl) throws IOException {
        this.writeIndicator("'", true, false, false);
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            String string2;
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl2) {
                if (c == '\u0000' || c != ' ') {
                    if (n + 1 == i && this.column > this.bestWidth && bl && n != 0 && i != string.length()) {
                        this.writeIndent();
                    } else {
                        string2 = string.substring(n, i);
                        this.column += string2.length();
                        this.stream.write(string2);
                    }
                    n = i;
                }
            } else if (bl3) {
                if (c == '\u0000' || "\n\u0085\u2028\u2029".indexOf(c) == -1) {
                    if (string.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    string2 = string.substring(n, i);
                    for (char c2 : string2.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    this.writeIndent();
                    n = i;
                }
            } else if ((c == '\u0000' || " \n\u0085\u2028\u2029".indexOf(c) != -1 || c == '\'') && n < i) {
                string2 = string.substring(n, i);
                this.column += string2.length();
                this.stream.write(string2);
                n = i;
            }
            if (c == '\'') {
                string2 = "''";
                this.column += 2;
                this.stream.write(string2);
                n = i + 1;
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = "\n\u0085\u2028\u2029".indexOf(c) != -1;
        }
        this.writeIndicator("'", false, false, false);
    }

    private void writeDoubleQuoted(String string, boolean bl) throws IOException {
        this.writeIndicator("\"", true, false, false);
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            String string2;
            Character c = null;
            if (i < string.length()) {
                c = Character.valueOf(string.charAt(i));
            }
            if (c == null || "\"\\\u0085\u2028\u2029\ufeff".indexOf(c.charValue()) != -1 || ' ' > c.charValue() || c.charValue() > '~') {
                if (n < i) {
                    string2 = string.substring(n, i);
                    this.column += string2.length();
                    this.stream.write(string2);
                    n = i;
                }
                if (c != null) {
                    String string3;
                    if (ESCAPE_REPLACEMENTS.containsKey(new Character(c.charValue()))) {
                        string2 = "\\" + ESCAPE_REPLACEMENTS.get(new Character(c.charValue()));
                    } else if (c.charValue() <= '\u00ff') {
                        string3 = "0" + Integer.toString(c.charValue(), 16);
                        string2 = "\\x" + string3.substring(string3.length() - 2);
                    } else {
                        string3 = "000" + Integer.toString(c.charValue(), 16);
                        string2 = "\\u" + string3.substring(string3.length() - 4);
                    }
                    this.column += string2.length();
                    this.stream.write(string2);
                    n = i + 1;
                }
            }
            if (0 >= i || i >= string.length() - 1 || c.charValue() != ' ' && n < i || this.column + (i - n) <= this.bestWidth || !bl) continue;
            string2 = n >= i ? "\\" : string.substring(n, i) + "\\";
            if (n < i) {
                n = i;
            }
            this.column += string2.length();
            this.stream.write(string2);
            this.writeIndent();
            this.whitespace = false;
            this.indention = false;
            if (string.charAt(n) != ' ') continue;
            string2 = "\\";
            this.column += string2.length();
            this.stream.write(string2);
        }
        this.writeIndicator("\"", false, false, false);
    }

    private String determineBlockHints(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            char c;
            if (" \n\u0085\u2028\u2029".indexOf(string.charAt(0)) != -1) {
                stringBuffer.append(this.bestIndent);
            }
            if ("\n\u0085\u2028\u2029".indexOf(c = string.charAt(string.length() - 1)) == -1) {
                stringBuffer.append("-");
            } else if (string.length() == 1 || "\n\u0085\u2028\u2029".indexOf(string.charAt(string.length() - 2)) != -1) {
                stringBuffer.append("+");
            }
        }
        return stringBuffer.toString();
    }

    void writeFolded(String string) throws IOException {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator(">" + string2, true, false, false);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '+') {
            this.openEnded = true;
        }
        this.writeLineBreak(null);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            String string3;
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl3) {
                if (c == '\u0000' || "\n\u000085\u2028\u2029".indexOf(c) == -1) {
                    if (!bl && c != '\u0000' && c != ' ' && string.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    bl = c == ' ';
                    string3 = string.substring(n, i);
                    for (char c2 : string3.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    if (c != '\u0000') {
                        this.writeIndent();
                    }
                    n = i;
                }
            } else if (bl2) {
                if (c != ' ') {
                    if (n + 1 == i && this.column > this.bestWidth) {
                        this.writeIndent();
                    } else {
                        string3 = string.substring(n, i);
                        this.column += string3.length();
                        this.stream.write(string3);
                    }
                    n = i;
                }
            } else if (c == '\u0000' || " \n\u000085\u2028\u2029".indexOf(c) != -1) {
                string3 = string.substring(n, i);
                this.column += string3.length();
                this.stream.write(string3);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = i;
            }
            if (c == '\u0000') continue;
            bl3 = "\n\u0085\u2028\u2029".indexOf(c) != -1;
            bl2 = c == ' ';
        }
    }

    void writeLiteral(String string) throws IOException {
        String string2 = this.determineBlockHints(string);
        this.writeIndicator("|" + string2, true, false, false);
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '+') {
            this.openEnded = true;
        }
        this.writeLineBreak(null);
        boolean bl = true;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            String string3;
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl) {
                if (c == '\u0000' || "\n\u0085\u2028\u2029".indexOf(c) == -1) {
                    string3 = string.substring(n, i);
                    for (char c2 : string3.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    if (c != '\u0000') {
                        this.writeIndent();
                    }
                    n = i;
                }
            } else if (c == '\u0000' || "\n\u0085\u2028\u2029".indexOf(c) != -1) {
                string3 = string.substring(n, i);
                this.stream.write(string3);
                if (c == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = i;
            }
            if (c == '\u0000') continue;
            bl = "\n\u0085\u2028\u2029".indexOf(c) != -1;
        }
    }

    void writePlain(String string, boolean bl) throws IOException {
        if (this.rootContext) {
            this.openEnded = true;
        }
        if (string == null || "".equals(string)) {
            return;
        }
        if (!this.whitespace) {
            String string2 = " ";
            this.column += string2.length();
            this.stream.write(string2);
        }
        this.whitespace = false;
        this.indention = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (int i = 0; i <= string.length(); ++i) {
            String string3;
            char c = '\u0000';
            if (i < string.length()) {
                c = string.charAt(i);
            }
            if (bl2) {
                if (c != ' ') {
                    if (n + 1 == i && this.column > this.bestWidth && bl) {
                        this.writeIndent();
                        this.whitespace = false;
                        this.indention = false;
                    } else {
                        string3 = string.substring(n, i);
                        this.column += string3.length();
                        this.stream.write(string3);
                    }
                    n = i;
                }
            } else if (bl3) {
                if ("\n\u0085\u2028\u2029".indexOf(c) == -1) {
                    if (string.charAt(n) == '\n') {
                        this.writeLineBreak(null);
                    }
                    string3 = string.substring(n, i);
                    for (char c2 : string3.toCharArray()) {
                        if (c2 == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(c2));
                    }
                    this.writeIndent();
                    this.whitespace = false;
                    this.indention = false;
                    n = i;
                }
            } else if (c == '\u0000' || "\n\u0085\u2028\u2029".indexOf(c) != -1) {
                string3 = string.substring(n, i);
                this.column += string3.length();
                this.stream.write(string3);
                n = i;
            }
            if (c == '\u0000') continue;
            bl2 = c == ' ';
            bl3 = "\n\u0085\u2028\u2029".indexOf(c) != -1;
        }
    }

    static {
        ESCAPE_REPLACEMENTS.put(new Character('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(new Character('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(new Character('\b'), "b");
        ESCAPE_REPLACEMENTS.put(new Character('\t'), "t");
        ESCAPE_REPLACEMENTS.put(new Character('\n'), "n");
        ESCAPE_REPLACEMENTS.put(new Character('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(new Character('\f'), "f");
        ESCAPE_REPLACEMENTS.put(new Character('\r'), "r");
        ESCAPE_REPLACEMENTS.put(new Character('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(new Character('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(new Character('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(new Character('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(new Character('\u00a0'), "_");
        ESCAPE_REPLACEMENTS.put(new Character('\u2028'), "L");
        ESCAPE_REPLACEMENTS.put(new Character('\u2029'), "P");
        DEFAULT_TAG_PREFIXES = new LinkedHashMap<String, String>();
        DEFAULT_TAG_PREFIXES.put("!", "!");
        DEFAULT_TAG_PREFIXES.put("tag:yaml.org,2002:", "!!");
        HANDLE_FORMAT = Pattern.compile("^![-_\\w]*!$");
        ANCHOR_FORMAT = Pattern.compile("^[-_\\w]*$");
    }

    private class ExpectBlockMappingValue
    implements EmitterState {
        private ExpectBlockMappingValue() {
        }

        @Override
        public void expect() throws IOException {
            Emitter.this.writeIndent();
            Emitter.this.writeIndicator(":", true, false, true);
            Emitter.this.states.push(new ExpectBlockMappingKey(false));
            Emitter.this.expectNode(false, false, true, false);
        }
    }

    private class ExpectBlockMappingSimpleValue
    implements EmitterState {
        private ExpectBlockMappingSimpleValue() {
        }

        @Override
        public void expect() throws IOException {
            Emitter.this.writeIndicator(":", false, false, false);
            Emitter.this.states.push(new ExpectBlockMappingKey(false));
            Emitter.this.expectNode(false, false, true, false);
        }
    }

    private class ExpectBlockMappingKey
    implements EmitterState {
        private boolean first;

        public ExpectBlockMappingKey(boolean bl) {
            this.first = bl;
        }

        @Override
        public void expect() throws IOException {
            if (!this.first && Emitter.this.event instanceof MappingEndEvent) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                Emitter.this.writeIndent();
                if (Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.push(new ExpectBlockMappingSimpleValue());
                    Emitter.this.expectNode(false, false, true, true);
                } else {
                    Emitter.this.writeIndicator("?", true, false, true);
                    Emitter.this.states.push(new ExpectBlockMappingValue());
                    Emitter.this.expectNode(false, false, true, false);
                }
            }
        }
    }

    private class ExpectFirstBlockMappingKey
    implements EmitterState {
        private ExpectFirstBlockMappingKey() {
        }

        @Override
        public void expect() throws IOException {
            new ExpectBlockMappingKey(true).expect();
        }
    }

    private class ExpectBlockSequenceItem
    implements EmitterState {
        private boolean first;

        public ExpectBlockSequenceItem(boolean bl) {
            this.first = bl;
        }

        @Override
        public void expect() throws IOException {
            if (!this.first && Emitter.this.event instanceof SequenceEndEvent) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                Emitter.this.writeIndent();
                Emitter.this.writeIndicator("-", true, false, true);
                Emitter.this.states.push(new ExpectBlockSequenceItem(false));
                Emitter.this.expectNode(false, true, false, false);
            }
        }
    }

    private class ExpectFirstBlockSequenceItem
    implements EmitterState {
        private ExpectFirstBlockSequenceItem() {
        }

        @Override
        public void expect() throws IOException {
            new ExpectBlockSequenceItem(true).expect();
        }
    }

    private class ExpectFlowMappingValue
    implements EmitterState {
        private ExpectFlowMappingValue() {
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth) {
                Emitter.this.writeIndent();
            }
            Emitter.this.writeIndicator(":", true, false, false);
            Emitter.this.states.push(new ExpectFlowMappingKey());
            Emitter.this.expectNode(false, false, true, false);
        }
    }

    private class ExpectFlowMappingSimpleValue
    implements EmitterState {
        private ExpectFlowMappingSimpleValue() {
        }

        @Override
        public void expect() throws IOException {
            Emitter.this.writeIndicator(":", false, false, false);
            Emitter.this.states.push(new ExpectFlowMappingKey());
            Emitter.this.expectNode(false, false, true, false);
        }
    }

    private class ExpectFlowMappingKey
    implements EmitterState {
        private ExpectFlowMappingKey() {
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.event instanceof MappingEndEvent) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndicator(",", false, false, false);
                    Emitter.this.writeIndent();
                }
                Emitter.this.writeIndicator("}", false, false, false);
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                Emitter.this.writeIndicator(",", false, false, false);
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth) {
                    Emitter.this.writeIndent();
                }
                if (!Emitter.this.canonical.booleanValue() && Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.push(new ExpectFlowMappingSimpleValue());
                    Emitter.this.expectNode(false, false, true, true);
                } else {
                    Emitter.this.writeIndicator("?", true, false, false);
                    Emitter.this.states.push(new ExpectFlowMappingValue());
                    Emitter.this.expectNode(false, false, true, false);
                }
            }
        }
    }

    private class ExpectFirstFlowMappingKey
    implements EmitterState {
        private ExpectFirstFlowMappingKey() {
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.event instanceof MappingEndEvent) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                Emitter.this.writeIndicator("}", false, false, false);
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth) {
                    Emitter.this.writeIndent();
                }
                if (!Emitter.this.canonical.booleanValue() && Emitter.this.checkSimpleKey()) {
                    Emitter.this.states.push(new ExpectFlowMappingSimpleValue());
                    Emitter.this.expectNode(false, false, true, true);
                } else {
                    Emitter.this.writeIndicator("?", true, false, false);
                    Emitter.this.states.push(new ExpectFlowMappingValue());
                    Emitter.this.expectNode(false, false, true, false);
                }
            }
        }
    }

    private class ExpectFlowSequenceItem
    implements EmitterState {
        private ExpectFlowSequenceItem() {
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.event instanceof SequenceEndEvent) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                if (Emitter.this.canonical.booleanValue()) {
                    Emitter.this.writeIndicator(",", false, false, false);
                    Emitter.this.writeIndent();
                }
                Emitter.this.writeIndicator("]", false, false, false);
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                Emitter.this.writeIndicator(",", false, false, false);
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.states.push(new ExpectFlowSequenceItem());
                Emitter.this.expectNode(false, true, false, false);
            }
        }
    }

    private class ExpectFirstFlowSequenceItem
    implements EmitterState {
        private ExpectFirstFlowSequenceItem() {
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.event instanceof SequenceEndEvent) {
                Emitter.this.indent = (Integer)Emitter.this.indents.pop();
                Emitter.this.flowLevel--;
                Emitter.this.writeIndicator("]", false, false, false);
                Emitter.this.state = (EmitterState)Emitter.this.states.pop();
            } else {
                if (Emitter.this.canonical.booleanValue() || Emitter.this.column > Emitter.this.bestWidth) {
                    Emitter.this.writeIndent();
                }
                Emitter.this.states.push(new ExpectFlowSequenceItem());
                Emitter.this.expectNode(false, true, false, false);
            }
        }
    }

    private class ExpectDocumentRoot
    implements EmitterState {
        private ExpectDocumentRoot() {
        }

        @Override
        public void expect() throws IOException {
            Emitter.this.states.push(new ExpectDocumentEnd());
            Emitter.this.expectNode(true, false, false, false);
        }
    }

    private class ExpectDocumentEnd
    implements EmitterState {
        private ExpectDocumentEnd() {
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.event instanceof DocumentEndEvent) {
                Emitter.this.writeIndent();
                if (((DocumentEndEvent)Emitter.this.event).getExplicit()) {
                    Emitter.this.writeIndicator("...", true, false, false);
                    Emitter.this.writeIndent();
                }
            } else {
                throw new EmitterException("expected DocumentEndEvent, but got " + Emitter.this.event);
            }
            Emitter.this.flushStream();
            Emitter.this.state = new ExpectDocumentStart(false);
        }
    }

    private class ExpectDocumentStart
    implements EmitterState {
        private boolean first;

        public ExpectDocumentStart(boolean bl) {
            this.first = bl;
        }

        @Override
        public void expect() throws IOException {
            if (Emitter.this.event instanceof DocumentStartEvent) {
                boolean bl;
                Object object;
                DocumentStartEvent documentStartEvent = (DocumentStartEvent)Emitter.this.event;
                if ((documentStartEvent.getVersion() != null || documentStartEvent.getTags() != null) && Emitter.this.openEnded) {
                    Emitter.this.writeIndicator("...", true, false, false);
                    Emitter.this.writeIndent();
                }
                if (documentStartEvent.getVersion() != null) {
                    object = Emitter.this.prepareVersion(documentStartEvent.getVersion());
                    Emitter.this.writeVersionDirective((String)object);
                }
                Emitter.this.tagPrefixes = new LinkedHashMap(DEFAULT_TAG_PREFIXES);
                if (documentStartEvent.getTags() != null) {
                    object = new TreeSet<String>(documentStartEvent.getTags().keySet());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = documentStartEvent.getTags().get(string);
                        Emitter.this.tagPrefixes.put(string2, string);
                        String string3 = Emitter.this.prepareTagHandle(string);
                        String string4 = Emitter.this.prepareTagPrefix(string2);
                        Emitter.this.writeTagDirective(string3, string4);
                    }
                }
                boolean bl2 = bl = this.first && !documentStartEvent.getExplicit() && Emitter.this.canonical == false && documentStartEvent.getVersion() == null && documentStartEvent.getTags() == null && !Emitter.this.checkEmptyDocument();
                if (!bl) {
                    Emitter.this.writeIndent();
                    Emitter.this.writeIndicator("---", true, false, false);
                    if (Emitter.this.canonical.booleanValue()) {
                        Emitter.this.writeIndent();
                    }
                }
                Emitter.this.state = new ExpectDocumentRoot();
            } else if (Emitter.this.event instanceof StreamEndEvent) {
                Emitter.this.writeStreamEnd();
                Emitter.this.state = new ExpectNothing();
            } else {
                throw new EmitterException("expected DocumentStartEvent, but got " + Emitter.this.event);
            }
        }
    }

    private class ExpectFirstDocumentStart
    implements EmitterState {
        private ExpectFirstDocumentStart() {
        }

        @Override
        public void expect() throws IOException {
            new ExpectDocumentStart(true).expect();
        }
    }

    private class ExpectNothing
    implements EmitterState {
        private ExpectNothing() {
        }

        @Override
        public void expect() throws IOException {
            throw new EmitterException("expecting nothing, but got " + Emitter.this.event);
        }
    }

    private class ExpectStreamStart
    implements EmitterState {
        private ExpectStreamStart() {
        }

        @Override
        public void expect() throws IOException {
            if (!(Emitter.this.event instanceof StreamStartEvent)) {
                throw new EmitterException("expected StreamStartEvent, but got " + Emitter.this.event);
            }
            Emitter.this.writeStreamStart();
            Emitter.this.state = new ExpectFirstDocumentStart();
        }
    }
}

