/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

public class literalTools {
    public static byte parseByte(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("string is null");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] cArray = string.toUpperCase().endsWith("T") ? string.substring(0, string.length() - 1).toCharArray() : string.toCharArray();
        int n = 0;
        int n2 = 10;
        boolean bl = false;
        if (cArray[n] == '-') {
            ++n;
            bl = true;
        }
        if (cArray[n] == '0') {
            if (++n == cArray.length) {
                return 0;
            }
            if (cArray[n] == 'x' || cArray[n] == 'X') {
                n2 = 16;
                ++n;
            } else if (Character.digit(cArray[n], 8) >= 0) {
                n2 = 8;
            }
        }
        byte by = 0;
        byte by2 = (byte)(127 / (n2 / 2));
        while (n < cArray.length) {
            int n3 = Character.digit(cArray[n], n2);
            if (n3 < 0) {
                throw new NumberFormatException("The string contains invalid an digit - '" + cArray[n] + "'");
            }
            byte by3 = (byte)(by * n2);
            if (by > by2) {
                throw new NumberFormatException(string + " cannot fit into a byte");
            }
            if (by3 < 0 && by3 >= -n3) {
                throw new NumberFormatException(string + " cannot fit into a byte");
            }
            by = (byte)(by3 + n3);
            ++n;
        }
        if (bl) {
            if (by == -128) {
                return by;
            }
            if (by < 0) {
                throw new NumberFormatException(string + " cannot fit into a byte");
            }
            return (byte)(by * -1);
        }
        return by;
    }

    public static short parseShort(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("string is null");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] cArray = string.toUpperCase().endsWith("S") ? string.substring(0, string.length() - 1).toCharArray() : string.toCharArray();
        int n = 0;
        int n2 = 10;
        boolean bl = false;
        if (cArray[n] == '-') {
            ++n;
            bl = true;
        }
        if (cArray[n] == '0') {
            if (++n == cArray.length) {
                return 0;
            }
            if (cArray[n] == 'x' || cArray[n] == 'X') {
                n2 = 16;
                ++n;
            } else if (Character.digit(cArray[n], 8) >= 0) {
                n2 = 8;
            }
        }
        short s = 0;
        short s2 = (short)(Short.MAX_VALUE / (n2 / 2));
        while (n < cArray.length) {
            int n3 = Character.digit(cArray[n], n2);
            if (n3 < 0) {
                throw new NumberFormatException("The string contains invalid an digit - '" + cArray[n] + "'");
            }
            short s3 = (short)(s * n2);
            if (s > s2) {
                throw new NumberFormatException(string + " cannot fit into a short");
            }
            if (s3 < 0 && s3 >= -n3) {
                throw new NumberFormatException(string + " cannot fit into a short");
            }
            s = (short)(s3 + n3);
            ++n;
        }
        if (bl) {
            if (s == Short.MIN_VALUE) {
                return s;
            }
            if (s < 0) {
                throw new NumberFormatException(string + " cannot fit into a short");
            }
            return (short)(s * -1);
        }
        return s;
    }

    public static int parseInt(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("string is null");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 10;
        boolean bl = false;
        if (cArray[n] == '-') {
            ++n;
            bl = true;
        }
        if (cArray[n] == '0') {
            if (++n == cArray.length) {
                return 0;
            }
            if (cArray[n] == 'x' || cArray[n] == 'X') {
                n2 = 16;
                ++n;
            } else if (Character.digit(cArray[n], 8) >= 0) {
                n2 = 8;
            }
        }
        int n3 = 0;
        int n4 = Integer.MAX_VALUE / (n2 / 2);
        while (n < cArray.length) {
            int n5 = Character.digit(cArray[n], n2);
            if (n5 < 0) {
                throw new NumberFormatException("The string contains an invalid digit - '" + cArray[n] + "'");
            }
            int n6 = n3 * n2;
            if (n3 > n4) {
                throw new NumberFormatException(string + " cannot fit into an int");
            }
            if (n6 < 0 && n6 >= -n5) {
                throw new NumberFormatException(string + " cannot fit into an int");
            }
            n3 = n6 + n5;
            ++n;
        }
        if (bl) {
            if (n3 == Integer.MIN_VALUE) {
                return n3;
            }
            if (n3 < 0) {
                throw new NumberFormatException(string + " cannot fit into an int");
            }
            return n3 * -1;
        }
        return n3;
    }

    public static long parseLong(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("string is null");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("string is blank");
        }
        char[] cArray = string.toUpperCase().endsWith("L") ? string.substring(0, string.length() - 1).toCharArray() : string.toCharArray();
        int n = 0;
        int n2 = 10;
        boolean bl = false;
        if (cArray[n] == '-') {
            ++n;
            bl = true;
        }
        if (cArray[n] == '0') {
            if (++n == cArray.length) {
                return 0L;
            }
            if (cArray[n] == 'x' || cArray[n] == 'X') {
                n2 = 16;
                ++n;
            } else if (Character.digit(cArray[n], 8) >= 0) {
                n2 = 8;
            }
        }
        long l = 0L;
        long l2 = Long.MAX_VALUE / (long)(n2 / 2);
        while (n < cArray.length) {
            int n3 = Character.digit(cArray[n], n2);
            if (n3 < 0) {
                throw new NumberFormatException("The string contains an invalid digit - '" + cArray[n] + "'");
            }
            long l3 = l * (long)n2;
            if (l > l2) {
                throw new NumberFormatException(string + " cannot fit into a long");
            }
            if (l3 < 0L && l3 >= (long)(-n3)) {
                throw new NumberFormatException(string + " cannot fit into a long");
            }
            l = l3 + (long)n3;
            ++n;
        }
        if (bl) {
            if (l == Long.MIN_VALUE) {
                return l;
            }
            if (l < 0L) {
                throw new NumberFormatException(string + " cannot fit into a long");
            }
            return l * -1L;
        }
        return l;
    }

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (l != 0L) {
            byArray[n] = (byte)l;
            l >>>= 8;
            ++n;
        }
        return byArray;
    }

    public static byte[] intToBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n != 0) {
            byArray[n2] = (byte)n;
            n >>>= 8;
            ++n2;
        }
        return byArray;
    }

    public static byte[] shortToBytes(short s) {
        byte[] byArray = new byte[]{(byte)s, (byte)(s >>> 8)};
        return byArray;
    }

    public static byte[] floatToBytes(float f) {
        return literalTools.intToBytes(Float.floatToRawIntBits(f));
    }

    public static byte[] doubleToBytes(double d) {
        return literalTools.longToBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] charToBytes(char c) {
        return literalTools.shortToBytes((short)c);
    }

    public static byte[] boolToBytes(boolean bl) {
        if (bl) {
            return new byte[]{1};
        }
        return new byte[]{0};
    }

    public static void checkInt(long l) {
        if (l > -1L || l < Integer.MIN_VALUE) {
            throw new NumberFormatException(Long.toString(l) + " cannot fit into an int");
        }
    }

    public static void checkShort(long l) {
        if (l > 65535L | l < -32768L) {
            throw new NumberFormatException(Long.toString(l) + " cannot fit into a short");
        }
    }

    public static void checkByte(long l) {
        if (l > 255L | l < -128L) {
            throw new NumberFormatException(Long.toString(l) + " cannot fit into a byte");
        }
    }

    public static void checkNibble(long l) {
        if (l > 15L | l < -8L) {
            throw new NumberFormatException(Long.toString(l) + " cannot fit into a nibble");
        }
    }
}

