/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.StringDataItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

public class ReadContext {
    private SparseArray<TypeListItem> typeListItems = new SparseArray(0);
    private SparseArray<AnnotationSetRefList> annotationSetRefLists = new SparseArray(0);
    private SparseArray<AnnotationSetItem> annotationSetItems = new SparseArray(0);
    private SparseArray<ClassDataItem> classDataItems = new SparseArray(0);
    private SparseArray<CodeItem> codeItems = new SparseArray(0);
    private SparseArray<StringDataItem> stringDataItems = new SparseArray(0);
    private SparseArray<DebugInfoItem> debugInfoItems = new SparseArray(0);
    private SparseArray<AnnotationItem> annotationItems = new SparseArray(0);
    private SparseArray<EncodedArrayItem> encodedArrayItems = new SparseArray(0);
    private SparseArray<AnnotationDirectoryItem> annotationDirectoryItems = new SparseArray(0);
    private SparseArray[] itemsByType = new SparseArray[]{null, null, null, null, null, null, this.typeListItems, this.annotationSetRefLists, this.annotationSetItems, this.classDataItems, this.codeItems, this.stringDataItems, this.debugInfoItems, this.annotationItems, this.encodedArrayItems, this.annotationDirectoryItems, null, null};
    private int[] sectionSizes = new int[18];
    private int[] sectionOffsets = new int[18];

    public ReadContext() {
        for (int i = 0; i < 18; ++i) {
            this.sectionSizes[i] = -1;
            this.sectionOffsets[i] = -1;
        }
    }

    public Item getOffsettedItemByOffset(ItemType itemType, int n) {
        assert (!itemType.isIndexedItem());
        SparseArray sparseArray = this.itemsByType[itemType.SectionIndex];
        Item item = (Item)sparseArray.get(n);
        if (item == null) {
            throw new ExceptionWithContext(String.format("Could not find the %s item at offset %#x", itemType.TypeName, n));
        }
        return item;
    }

    public Item getOptionalOffsettedItemByOffset(ItemType itemType, int n) {
        assert (!itemType.isIndexedItem());
        assert (!itemType.isIndexedItem());
        SparseArray sparseArray = this.itemsByType[itemType.SectionIndex];
        Item item = (Item)sparseArray.get(n);
        if (item == null && n != 0) {
            throw new ExceptionWithContext(String.format("Could not find the %s item at offset %#x", itemType.TypeName, n));
        }
        return item;
    }

    public void addSection(ItemType itemType, int n, int n2) {
        int n3 = this.sectionSizes[itemType.SectionIndex];
        if (n3 == -1) {
            this.sectionSizes[itemType.SectionIndex] = n;
        } else if (n3 != n) {
            throw new RuntimeException("The section size in the header and map for item type " + (Object)((Object)itemType) + " do not match");
        }
        int n4 = this.sectionOffsets[itemType.SectionIndex];
        if (n4 == -1) {
            this.sectionOffsets[itemType.SectionIndex] = n2;
        } else if (n4 != n2) {
            throw new RuntimeException("The section offset in the header and map for item type " + (Object)((Object)itemType) + " do not match");
        }
    }

    public void setItemsForSection(ItemType itemType, List<? extends Item> list) {
        assert (!itemType.isIndexedItem());
        SparseArray sparseArray = this.itemsByType[itemType.SectionIndex];
        sparseArray.ensureCapacity(list.size());
        for (Item item : list) {
            sparseArray.append(item.getOffset(), item);
        }
    }

    public int getSectionSize(ItemType itemType) {
        return this.sectionSizes[itemType.SectionIndex];
    }

    public int getSectionOffset(ItemType itemType) {
        return this.sectionOffsets[itemType.SectionIndex];
    }
}

