/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class MapItem
extends Item<MapItem> {
    protected MapItem(DexFile dexFile) {
        super(dexFile);
    }

    @Override
    protected int placeItem(int n) {
        Section[] sectionArray = this.dexFile.getOrderedSections();
        return n + 4 + (sectionArray.length + 2) * 12;
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n = input.readInt();
        for (int i = 0; i < n; ++i) {
            ItemType itemType = ItemType.fromInt(input.readShort());
            input.readShort();
            int n2 = input.readInt();
            int n3 = input.readInt();
            readContext.addSection(itemType, n2, n3);
        }
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        assert (this.getOffset() > 0);
        Section[] sectionArray = this.dexFile.getOrderedSections();
        annotatedOutput.annotate("map_size: 0x" + Integer.toHexString(sectionArray.length + 2) + " (" + Integer.toString(sectionArray.length + 2) + ")");
        annotatedOutput.writeInt(sectionArray.length + 2);
        int n = 0;
        annotatedOutput.annotate(0, "[" + n++ + "]");
        annotatedOutput.indent();
        this.writeSectionInfo(annotatedOutput, ItemType.TYPE_HEADER_ITEM, 1, 0);
        annotatedOutput.deindent();
        for (Section section : this.dexFile.getOrderedSections()) {
            annotatedOutput.annotate(0, "[" + n++ + "]");
            annotatedOutput.indent();
            this.writeSectionInfo(annotatedOutput, section.ItemType, section.getItems().size(), section.getOffset());
            annotatedOutput.deindent();
        }
        annotatedOutput.annotate(0, "[" + n++ + "]");
        annotatedOutput.indent();
        this.writeSectionInfo(annotatedOutput, ItemType.TYPE_MAP_LIST, 1, this.dexFile.MapItem.getOffset());
        annotatedOutput.deindent();
    }

    private void writeSectionInfo(AnnotatedOutput annotatedOutput, ItemType itemType, int n, int n2) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(2, "item_type: " + (Object)((Object)itemType));
            annotatedOutput.annotate(2, "unused");
            annotatedOutput.annotate(4, "section_size: 0x" + Integer.toHexString(n) + " (" + n + ")");
            annotatedOutput.annotate(4, "section_off: 0x" + Integer.toHexString(n2));
        }
        annotatedOutput.writeShort(itemType.MapValue);
        annotatedOutput.writeShort(0);
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n2);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_MAP_LIST;
    }

    @Override
    public int compareTo(MapItem mapItem) {
        return 0;
    }

    @Override
    public String getConciseIdentity() {
        return "map_item";
    }
}

