/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemFactory;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;

public class IndexedSection<T extends Item>
extends Section<T> {
    public IndexedSection(DexFile dexFile, ItemType itemType) {
        super(dexFile, itemType);
    }

    @Override
    protected void readItems(Input input, ReadContext readContext) {
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = ItemFactory.makeItem(this.ItemType, this.DexFile);
            this.items.set(i, item);
            item.readFrom(input, i, readContext);
        }
    }

    public T getOptionalItemByIndex(int n) {
        if (n == -1) {
            return null;
        }
        return this.getItemByIndex(n);
    }

    public T getItemByIndex(int n) {
        try {
            return (T)((Item)this.items.get(n));
        }
        catch (Exception exception) {
            throw ExceptionWithContext.withContext(exception, "Error occured while retrieving the " + this.ItemType.TypeName + " item at index " + n);
        }
    }
}

