/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.Util.ExceptionWithContext;

public class AnalyzedInstruction
implements Comparable<AnalyzedInstruction> {
    protected Instruction instruction;
    protected final int instructionIndex;
    protected final TreeSet<AnalyzedInstruction> predecessors = new TreeSet();
    protected final LinkedList<AnalyzedInstruction> successors = new LinkedList();
    protected final RegisterType[] preRegisterMap;
    protected final RegisterType[] postRegisterMap;
    protected final Instruction originalInstruction;
    protected boolean dead = false;

    public AnalyzedInstruction(Instruction instruction, int n, int n2) {
        this.instruction = instruction;
        this.originalInstruction = instruction;
        this.instructionIndex = n;
        this.postRegisterMap = new RegisterType[n2];
        this.preRegisterMap = new RegisterType[n2];
        RegisterType registerType = RegisterType.getRegisterType(RegisterType.Category.Unknown, null);
        for (int i = 0; i < n2; ++i) {
            this.preRegisterMap[i] = registerType;
            this.postRegisterMap[i] = registerType;
        }
    }

    public int getInstructionIndex() {
        return this.instructionIndex;
    }

    public int getPredecessorCount() {
        return this.predecessors.size();
    }

    public SortedSet<AnalyzedInstruction> getPredecessors() {
        return Collections.unmodifiableSortedSet(this.predecessors);
    }

    protected boolean addPredecessor(AnalyzedInstruction analyzedInstruction) {
        return this.predecessors.add(analyzedInstruction);
    }

    protected void addSuccessor(AnalyzedInstruction analyzedInstruction) {
        this.successors.add(analyzedInstruction);
    }

    protected void setDeodexedInstruction(Instruction instruction) {
        assert (this.originalInstruction.opcode.odexOnly());
        this.instruction = instruction;
    }

    protected void restoreOdexedInstruction() {
        assert (this.originalInstruction.opcode.odexOnly());
        this.instruction = this.originalInstruction;
    }

    public int getSuccessorCount() {
        return this.successors.size();
    }

    public List<AnalyzedInstruction> getSuccesors() {
        return Collections.unmodifiableList(this.successors);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public Instruction getOriginalInstruction() {
        return this.originalInstruction;
    }

    public boolean isDead() {
        return this.dead;
    }

    public boolean isBeginningInstruction() {
        if (this.predecessors.size() == 0) {
            return false;
        }
        return this.predecessors.first().instructionIndex == -1;
    }

    protected boolean mergeRegister(int n, RegisterType registerType, BitSet bitSet) {
        assert (n >= 0 && n < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType registerType2 = this.preRegisterMap[n];
        RegisterType registerType3 = registerType2.merge(registerType);
        if (registerType3 == registerType2) {
            return false;
        }
        this.preRegisterMap[n] = registerType3;
        bitSet.clear(this.instructionIndex);
        if (!this.setsRegister(n)) {
            this.postRegisterMap[n] = registerType3;
            return true;
        }
        return false;
    }

    protected RegisterType mergePreRegisterTypeFromPredecessors(int n) {
        RegisterType registerType = null;
        for (AnalyzedInstruction analyzedInstruction : this.predecessors) {
            RegisterType registerType2 = analyzedInstruction.postRegisterMap[n];
            assert (registerType2 != null);
            registerType = registerType2.merge(registerType);
        }
        return registerType;
    }

    protected boolean setPostRegisterType(int n, RegisterType registerType) {
        assert (n >= 0 && n < this.postRegisterMap.length);
        assert (registerType != null);
        RegisterType registerType2 = this.postRegisterMap[n];
        if (registerType2 == registerType) {
            return false;
        }
        this.postRegisterMap[n] = registerType;
        return true;
    }

    protected boolean isInvokeInit() {
        if (this.instruction == null || this.instruction.opcode != Opcode.INVOKE_DIRECT && this.instruction.opcode != Opcode.INVOKE_DIRECT_RANGE && this.instruction.opcode != Opcode.INVOKE_DIRECT_EMPTY) {
            return false;
        }
        InstructionWithReference instructionWithReference = (InstructionWithReference)this.instruction;
        Item item = instructionWithReference.getReferencedItem();
        assert (item.getItemType() == ItemType.TYPE_METHOD_ID_ITEM);
        MethodIdItem methodIdItem = (MethodIdItem)item;
        return methodIdItem.getMethodName().getStringValue().equals("<init>");
    }

    public boolean setsRegister() {
        return this.instruction.opcode.setsRegister();
    }

    public boolean setsWideRegister() {
        return this.instruction.opcode.setsWideRegister();
    }

    public boolean setsRegister(int n) {
        if (this.isInvokeInit()) {
            Object object;
            int n2;
            if (this.instruction instanceof FiveRegisterInstruction) {
                n2 = ((FiveRegisterInstruction)((Object)this.instruction)).getRegisterD();
            } else {
                assert (this.instruction instanceof RegisterRangeInstruction);
                object = (RegisterRangeInstruction)((Object)this.instruction);
                assert (object.getRegCount() > 0);
                n2 = object.getStartRegister();
            }
            if (n == n2) {
                return true;
            }
            object = this.getPreInstructionRegisterType(n);
            if (((RegisterType)object).category != RegisterType.Category.UninitRef && ((RegisterType)object).category != RegisterType.Category.UninitThis) {
                return false;
            }
            return this.getPreInstructionRegisterType(n) == object;
        }
        if (!this.setsRegister()) {
            return false;
        }
        int n3 = this.getDestinationRegister();
        if (n == n3) {
            return true;
        }
        return this.setsWideRegister() && n == n3 + 1;
    }

    public int getDestinationRegister() {
        if (!this.instruction.opcode.setsRegister()) {
            throw new ExceptionWithContext("Cannot call getDestinationRegister() for an instruction that doesn't store a value");
        }
        return ((SingleRegisterInstruction)((Object)this.instruction)).getRegisterA();
    }

    public int getRegisterCount() {
        return this.postRegisterMap.length;
    }

    public RegisterType getPostInstructionRegisterType(int n) {
        return this.postRegisterMap[n];
    }

    public RegisterType getPreInstructionRegisterType(int n) {
        return this.preRegisterMap[n];
    }

    @Override
    public int compareTo(AnalyzedInstruction analyzedInstruction) {
        if (this.instructionIndex < analyzedInstruction.instructionIndex) {
            return -1;
        }
        if (this.instructionIndex == analyzedInstruction.instructionIndex) {
            return 0;
        }
        return 1;
    }
}

