/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.ArrayEncodedSubValue;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.IndexedSection;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.TypeUtils;

public class ClassDefItem
extends Item<ClassDefItem> {
    private TypeIdItem classType;
    private int accessFlags;
    private TypeIdItem superType;
    private TypeListItem implementedInterfaces;
    private StringIdItem sourceFile;
    private AnnotationDirectoryItem annotations;
    private ClassDataItem classData;
    private EncodedArrayItem staticFieldInitializers;

    protected ClassDefItem(DexFile dexFile) {
        super(dexFile);
    }

    private ClassDefItem(DexFile dexFile, TypeIdItem typeIdItem, int n, TypeIdItem typeIdItem2, TypeListItem typeListItem, StringIdItem stringIdItem, AnnotationDirectoryItem annotationDirectoryItem, ClassDataItem classDataItem, EncodedArrayItem encodedArrayItem) {
        super(dexFile);
        assert (typeIdItem != null);
        this.classType = typeIdItem;
        this.accessFlags = n;
        this.superType = typeIdItem2;
        this.implementedInterfaces = typeListItem;
        this.sourceFile = stringIdItem;
        this.annotations = annotationDirectoryItem;
        this.classData = classDataItem;
        this.staticFieldInitializers = encodedArrayItem;
        if (classDataItem != null) {
            classDataItem.setParent(this);
        }
        if (annotationDirectoryItem != null) {
            annotationDirectoryItem.setParent(this);
        }
    }

    public static ClassDefItem internClassDefItem(DexFile dexFile, TypeIdItem typeIdItem, int n, TypeIdItem typeIdItem2, TypeListItem typeListItem, StringIdItem stringIdItem, AnnotationDirectoryItem annotationDirectoryItem, ClassDataItem classDataItem, List<StaticFieldInitializer> list) {
        EncodedArrayItem encodedArrayItem = null;
        if (!dexFile.getInplace() && list != null && list.size() > 0) {
            assert (classDataItem != null);
            assert (list.size() == classDataItem.getStaticFields().length);
            encodedArrayItem = ClassDefItem.makeStaticFieldInitializersItem(dexFile, list);
        }
        ClassDefItem classDefItem = new ClassDefItem(dexFile, typeIdItem, n, typeIdItem2, typeListItem, stringIdItem, annotationDirectoryItem, classDataItem, encodedArrayItem);
        return dexFile.ClassDefsSection.intern(classDefItem);
    }

    public static ClassDefItem lookupClassDefItem(DexFile dexFile, TypeIdItem typeIdItem, int n, TypeIdItem typeIdItem2, TypeListItem typeListItem, StringIdItem stringIdItem, AnnotationDirectoryItem annotationDirectoryItem, ClassDataItem classDataItem, List<StaticFieldInitializer> list) {
        EncodedArrayItem encodedArrayItem = null;
        if (!dexFile.getInplace() && list != null && list.size() > 0) {
            assert (classDataItem != null);
            assert (list.size() == classDataItem.getStaticFields().length);
            encodedArrayItem = ClassDefItem.makeStaticFieldInitializersItem(dexFile, list);
        }
        ClassDefItem classDefItem = new ClassDefItem(dexFile, typeIdItem, n, typeIdItem2, typeListItem, stringIdItem, annotationDirectoryItem, classDataItem, encodedArrayItem);
        return dexFile.ClassDefsSection.getInternedItem(classDefItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        this.classType = this.dexFile.TypeIdsSection.getItemByIndex(input.readInt());
        this.accessFlags = input.readInt();
        this.superType = this.dexFile.TypeIdsSection.getOptionalItemByIndex(input.readInt());
        this.implementedInterfaces = (TypeListItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_TYPE_LIST, input.readInt());
        this.sourceFile = this.dexFile.StringIdsSection.getOptionalItemByIndex(input.readInt());
        this.annotations = (AnnotationDirectoryItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM, input.readInt());
        this.classData = (ClassDataItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_CLASS_DATA_ITEM, input.readInt());
        this.staticFieldInitializers = (EncodedArrayItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ENCODED_ARRAY_ITEM, input.readInt());
        if (this.classData != null) {
            this.classData.setParent(this);
        }
        if (this.annotations != null) {
            this.annotations.setParent(this);
        }
    }

    @Override
    protected int placeItem(int n) {
        return n + 32;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "class_type: " + this.classType.getTypeDescriptor());
            annotatedOutput.annotate(4, "access_flags: " + AccessFlags.formatAccessFlagsForClass(this.accessFlags));
            annotatedOutput.annotate(4, "superclass_type: " + (this.superType == null ? "" : this.superType.getTypeDescriptor()));
            annotatedOutput.annotate(4, "interfaces: " + (this.implementedInterfaces == null ? "" : this.implementedInterfaces.getTypeListString(" ")));
            annotatedOutput.annotate(4, "source_file: " + (this.sourceFile == null ? "" : this.sourceFile.getStringValue()));
            annotatedOutput.annotate(4, "annotations_off: " + (this.annotations == null ? "" : "0x" + Integer.toHexString(this.annotations.getOffset())));
            annotatedOutput.annotate(4, "class_data_off:" + (this.classData == null ? "" : "0x" + Integer.toHexString(this.classData.getOffset())));
            annotatedOutput.annotate(4, "static_values_off: " + (this.staticFieldInitializers == null ? "" : "0x" + Integer.toHexString(this.staticFieldInitializers.getOffset())));
        }
        annotatedOutput.writeInt(this.classType.getIndex());
        annotatedOutput.writeInt(this.accessFlags);
        annotatedOutput.writeInt(this.superType == null ? -1 : this.superType.getIndex());
        annotatedOutput.writeInt(this.implementedInterfaces == null ? 0 : this.implementedInterfaces.getOffset());
        annotatedOutput.writeInt(this.sourceFile == null ? -1 : this.sourceFile.getIndex());
        annotatedOutput.writeInt(this.annotations == null ? 0 : this.annotations.getOffset());
        annotatedOutput.writeInt(this.classData == null ? 0 : this.classData.getOffset());
        annotatedOutput.writeInt(this.staticFieldInitializers == null ? 0 : this.staticFieldInitializers.getOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CLASS_DEF_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "class_def_item: " + this.classType.getTypeDescriptor();
    }

    @Override
    public int compareTo(ClassDefItem classDefItem) {
        return this.getOffset() - classDefItem.getOffset();
    }

    public TypeIdItem getClassType() {
        return this.classType;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public TypeIdItem getSuperclass() {
        return this.superType;
    }

    public TypeListItem getInterfaces() {
        return this.implementedInterfaces;
    }

    public StringIdItem getSourceFile() {
        return this.sourceFile;
    }

    public AnnotationDirectoryItem getAnnotations() {
        return this.annotations;
    }

    public ClassDataItem getClassData() {
        return this.classData;
    }

    public EncodedArrayItem getStaticFieldInitializers() {
        return this.staticFieldInitializers;
    }

    public static int placeClassDefItems(IndexedSection<ClassDefItem> indexedSection, int n) {
        ClassDefPlacer classDefPlacer = new ClassDefPlacer(indexedSection);
        return classDefPlacer.placeSection(n);
    }

    private static EncodedArrayItem makeStaticFieldInitializersItem(DexFile dexFile, List<StaticFieldInitializer> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int n = list.size();
        Collections.sort(list);
        int n2 = -1;
        for (int i = n - 1; i >= 0; --i) {
            StaticFieldInitializer staticFieldInitializer = list.get(i);
            if (staticFieldInitializer.value == null || staticFieldInitializer.value.compareTo(TypeUtils.makeDefaultValueForType(dexFile, staticFieldInitializer.field.field.getFieldType().getTypeDescriptor())) == 0) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            return null;
        }
        EncodedValue[] encodedValueArray = new EncodedValue[n2 + 1];
        for (int i = 0; i <= n2; ++i) {
            StaticFieldInitializer staticFieldInitializer = list.get(i);
            EncodedValue encodedValue = staticFieldInitializer.value;
            if (encodedValue == null) {
                encodedValue = TypeUtils.makeDefaultValueForType(dexFile, staticFieldInitializer.field.field.getFieldType().getTypeDescriptor());
            }
            encodedValueArray[i] = encodedValue;
        }
        ArrayEncodedSubValue arrayEncodedSubValue = new ArrayEncodedSubValue(encodedValueArray);
        return EncodedArrayItem.internEncodedArrayItem(dexFile, arrayEncodedSubValue);
    }

    public static class StaticFieldInitializer
    implements Comparable<StaticFieldInitializer> {
        public final EncodedValue value;
        public final ClassDataItem.EncodedField field;

        public StaticFieldInitializer(EncodedValue encodedValue, ClassDataItem.EncodedField encodedField) {
            this.value = encodedValue;
            this.field = encodedField;
        }

        @Override
        public int compareTo(StaticFieldInitializer staticFieldInitializer) {
            return this.field.compareTo(staticFieldInitializer.field);
        }
    }

    private static class ClassDefPlacer {
        private final IndexedSection<ClassDefItem> section;
        private final HashMap<TypeIdItem, ClassDefItem> unplacedClassDefsByType = new HashMap();
        private int currentIndex = 0;
        private int currentOffset;

        public ClassDefPlacer(IndexedSection<ClassDefItem> indexedSection) {
            this.section = indexedSection;
            for (ClassDefItem classDefItem : indexedSection.items) {
                TypeIdItem typeIdItem = classDefItem.classType;
                this.unplacedClassDefsByType.put(typeIdItem, classDefItem);
            }
        }

        public int placeSection(int n) {
            this.currentOffset = n;
            if (this.section.DexFile.getSortAllItems()) {
                Collections.sort(this.section.items, new Comparator<ClassDefItem>(){

                    @Override
                    public int compare(ClassDefItem classDefItem, ClassDefItem classDefItem2) {
                        return classDefItem.getClassType().compareTo(classDefItem2.getClassType());
                    }
                });
            }
            for (ClassDefItem classDefItem : this.section.items) {
                classDefItem.offset = -1;
            }
            for (ClassDefItem classDefItem : this.section.items) {
                this.placeClass(classDefItem);
            }
            for (ClassDefItem classDefItem : this.unplacedClassDefsByType.values()) {
                this.section.items.set(classDefItem.getIndex(), classDefItem);
            }
            return this.currentOffset;
        }

        private void placeClass(ClassDefItem classDefItem) {
            if (classDefItem.getOffset() == -1) {
                TypeListItem typeListItem;
                TypeIdItem typeIdItem = classDefItem.superType;
                ClassDefItem classDefItem2 = this.unplacedClassDefsByType.get(typeIdItem);
                if (classDefItem2 != null) {
                    this.placeClass(classDefItem2);
                }
                if ((typeListItem = classDefItem.implementedInterfaces) != null) {
                    for (TypeIdItem typeIdItem2 : typeListItem.getTypes()) {
                        ClassDefItem classDefItem3 = this.unplacedClassDefsByType.get(typeIdItem2);
                        if (classDefItem3 == null) continue;
                        this.placeClass(classDefItem3);
                    }
                }
                this.currentOffset = classDefItem.placeAt(this.currentOffset, this.currentIndex++);
                this.unplacedClassDefsByType.remove(classDefItem.classType);
            }
        }
    }
}

