/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.ReferenceFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.InstructionWithReference;
import org.jf.dexlib.Code.LiteralInstruction;
import org.jf.dexlib.Code.OdexedFieldAccess;
import org.jf.dexlib.Code.OdexedInvokeVirtual;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Item;

public class InstructionMethodItem<T extends Instruction>
extends MethodItem {
    protected final CodeItem codeItem;
    protected final T instruction;

    public InstructionMethodItem(CodeItem codeItem, int n, T t) {
        super(n);
        this.codeItem = codeItem;
        this.instruction = t;
    }

    @Override
    public double getSortOrder() {
        return 100.0;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        switch (((Instruction)this.instruction).getFormat()) {
            case Format10t: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeTargetLabel(indentingWriter);
                return true;
            }
            case Format10x: {
                this.writeOpcode(indentingWriter);
                return true;
            }
            case Format11n: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeLiteral(indentingWriter);
                return true;
            }
            case Format11x: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                return true;
            }
            case Format12x: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                return true;
            }
            case Format20t: 
            case Format30t: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeTargetLabel(indentingWriter);
                return true;
            }
            case Format21c: 
            case Format31c: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeReference(indentingWriter);
                return true;
            }
            case Format21h: 
            case Format21s: 
            case Format31i: 
            case Format51l: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeLiteral(indentingWriter);
                return true;
            }
            case Format21t: 
            case Format31t: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeTargetLabel(indentingWriter);
                return true;
            }
            case Format22b: 
            case Format22s: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeLiteral(indentingWriter);
                return true;
            }
            case Format22c: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeReference(indentingWriter);
                return true;
            }
            case Format22cs: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeFieldOffset(indentingWriter);
                return true;
            }
            case Format22t: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeTargetLabel(indentingWriter);
                return true;
            }
            case Format22x: 
            case Format32x: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                return true;
            }
            case Format23x: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeFirstRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeSecondRegister(indentingWriter);
                indentingWriter.write(", ");
                this.writeThirdRegister(indentingWriter);
                return true;
            }
            case Format35c: 
            case Format35s: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeInvokeRegisters(indentingWriter);
                indentingWriter.write(", ");
                this.writeReference(indentingWriter);
                return true;
            }
            case Format35ms: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeInvokeRegisters(indentingWriter);
                indentingWriter.write(", ");
                this.writeVtableIndex(indentingWriter);
                return true;
            }
            case Format3rc: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeInvokeRangeRegisters(indentingWriter);
                indentingWriter.write(", ");
                this.writeReference(indentingWriter);
                return true;
            }
            case Format3rms: {
                this.writeOpcode(indentingWriter);
                indentingWriter.write(32);
                this.writeInvokeRangeRegisters(indentingWriter);
                indentingWriter.write(", ");
                this.writeVtableIndex(indentingWriter);
                return true;
            }
        }
        assert (false);
        return false;
    }

    protected void writeOpcode(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write(((Instruction)this.instruction).opcode.name);
    }

    protected void writeTargetLabel(IndentingWriter indentingWriter) throws IOException {
        throw new RuntimeException();
    }

    protected void writeRegister(IndentingWriter indentingWriter, int n) throws IOException {
        RegisterFormatter.writeTo(indentingWriter, this.codeItem, n);
    }

    protected void writeFirstRegister(IndentingWriter indentingWriter) throws IOException {
        this.writeRegister(indentingWriter, ((SingleRegisterInstruction)this.instruction).getRegisterA());
    }

    protected void writeSecondRegister(IndentingWriter indentingWriter) throws IOException {
        this.writeRegister(indentingWriter, ((TwoRegisterInstruction)this.instruction).getRegisterB());
    }

    protected void writeThirdRegister(IndentingWriter indentingWriter) throws IOException {
        this.writeRegister(indentingWriter, ((ThreeRegisterInstruction)this.instruction).getRegisterC());
    }

    protected void writeInvokeRegisters(IndentingWriter indentingWriter) throws IOException {
        FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)this.instruction;
        byte by = fiveRegisterInstruction.getRegCount();
        indentingWriter.write(123);
        switch (by) {
            case 1: {
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterD());
                break;
            }
            case 2: {
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterD());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterE());
                break;
            }
            case 3: {
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterD());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterE());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterF());
                break;
            }
            case 4: {
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterD());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterE());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterF());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterG());
                break;
            }
            case 5: {
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterD());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterE());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterF());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterG());
                indentingWriter.write(", ");
                this.writeRegister(indentingWriter, fiveRegisterInstruction.getRegisterA());
            }
        }
        indentingWriter.write(125);
    }

    protected void writeInvokeRangeRegisters(IndentingWriter indentingWriter) throws IOException {
        RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)this.instruction;
        short s = registerRangeInstruction.getRegCount();
        if (s == 0) {
            indentingWriter.write("{}");
        } else {
            int n = registerRangeInstruction.getStartRegister();
            RegisterFormatter.writeRegisterRange(indentingWriter, this.codeItem, n, n + s - 1);
        }
    }

    protected void writeLiteral(IndentingWriter indentingWriter) throws IOException {
        LongRenderer.writeSignedIntOrLongTo(indentingWriter, ((LiteralInstruction)this.instruction).getLiteral());
    }

    protected void writeFieldOffset(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write("field@0x");
        indentingWriter.printLongAsHex(((OdexedFieldAccess)this.instruction).getFieldOffset());
    }

    protected void writeVtableIndex(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.write("vtable@0x");
        indentingWriter.printLongAsHex(((OdexedInvokeVirtual)this.instruction).getMethodIndex());
    }

    protected void writeReference(IndentingWriter indentingWriter) throws IOException {
        Item item = ((InstructionWithReference)this.instruction).getReferencedItem();
        ReferenceFormatter.writeReference(indentingWriter, item);
    }
}

