/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public abstract class Jar {
    private static final Set<String> mLoaded = new HashSet<String>();
    private static final Map<String, File> mExtracted = new HashMap<String, File>();

    public static File getResourceAsFile(String string) throws BrutException {
        File file = mExtracted.get(string);
        if (file == null) {
            file = Jar.extractToTmp(string);
            mExtracted.put(string, file);
        }
        return file;
    }

    public static void load(String string) {
        File file;
        if (mLoaded.contains(string)) {
            return;
        }
        try {
            file = Jar.getResourceAsFile(string);
        }
        catch (BrutException brutException) {
            throw new UnsatisfiedLinkError(brutException.getMessage());
        }
        System.load(file.getAbsolutePath());
    }

    public static File extractToTmp(String string) throws BrutException {
        return Jar.extractToTmp(string, "brut_util_Jar_");
    }

    public static File extractToTmp(String string, String string2) throws BrutException {
        try {
            InputStream inputStream = Class.class.getResourceAsStream(string);
            if (inputStream == null) {
                throw new FileNotFoundException(string);
            }
            File file = File.createTempFile(string2, null);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            return file;
        }
        catch (IOException iOException) {
            throw new BrutException("Could not extract resource: " + string, iOException);
        }
    }
}

