/*
 * Decompiled with CFR 0.152.
 */
package brut.directory;

import brut.directory.DirUtil;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.PathAlreadyExists;
import brut.directory.PathNotExist;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDirectory
implements Directory {
    protected Set<String> mFiles;
    protected Map<String, AbstractDirectory> mDirs;

    @Override
    public Set<String> getFiles() {
        return this.getFiles(false);
    }

    @Override
    public Set<String> getFiles(boolean bl) {
        if (this.mFiles == null) {
            this.loadFiles();
        }
        if (!bl) {
            return this.mFiles;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.mFiles);
        for (Map.Entry<String, AbstractDirectory> entry : this.getAbstractDirs().entrySet()) {
            for (String string : ((Directory)entry.getValue()).getFiles(true)) {
                linkedHashSet.add(entry.getKey() + '/' + string);
            }
        }
        return linkedHashSet;
    }

    @Override
    public boolean containsFile(String string) {
        SubPath subPath;
        try {
            subPath = this.getSubPath(string);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
        if (subPath.dir != null) {
            return subPath.dir.containsFile(subPath.path);
        }
        return this.getFiles().contains(subPath.path);
    }

    @Override
    public boolean containsDir(String string) {
        SubPath subPath;
        try {
            subPath = this.getSubPath(string);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
        if (subPath.dir != null) {
            return subPath.dir.containsDir(subPath.path);
        }
        return this.getAbstractDirs().containsKey(subPath.path);
    }

    @Override
    public Map<String, Directory> getDirs() throws UnsupportedOperationException {
        return this.getDirs(false);
    }

    @Override
    public Map<String, Directory> getDirs(boolean bl) throws UnsupportedOperationException {
        return new LinkedHashMap<String, Directory>(this.getAbstractDirs(bl));
    }

    @Override
    public InputStream getFileInput(String string) throws DirectoryException {
        SubPath subPath = this.getSubPath(string);
        if (subPath.dir != null) {
            return subPath.dir.getFileInput(subPath.path);
        }
        if (!this.getFiles().contains(subPath.path)) {
            throw new PathNotExist(string);
        }
        return this.getFileInputLocal(subPath.path);
    }

    @Override
    public OutputStream getFileOutput(String string) throws DirectoryException {
        Directory directory;
        ParsedPath parsedPath = this.parsePath(string);
        if (parsedPath.dir == null) {
            this.getFiles().add(parsedPath.subpath);
            return this.getFileOutputLocal(parsedPath.subpath);
        }
        try {
            directory = this.createDir(parsedPath.dir);
        }
        catch (PathAlreadyExists pathAlreadyExists) {
            directory = this.getAbstractDirs().get(parsedPath.dir);
        }
        return directory.getFileOutput(parsedPath.subpath);
    }

    @Override
    public Directory getDir(String string) throws PathNotExist {
        SubPath subPath = this.getSubPath(string);
        if (subPath.dir != null) {
            return subPath.dir.getDir(subPath.path);
        }
        if (!this.getAbstractDirs().containsKey(subPath.path)) {
            throw new PathNotExist(string);
        }
        return this.getAbstractDirs().get(subPath.path);
    }

    @Override
    public Directory createDir(String string) throws DirectoryException {
        AbstractDirectory abstractDirectory;
        ParsedPath parsedPath = this.parsePath(string);
        if (parsedPath.dir == null) {
            if (this.getAbstractDirs().containsKey(parsedPath.subpath)) {
                throw new PathAlreadyExists(string);
            }
            AbstractDirectory abstractDirectory2 = this.createDirLocal(parsedPath.subpath);
            this.getAbstractDirs().put(parsedPath.subpath, abstractDirectory2);
            return abstractDirectory2;
        }
        if (this.getAbstractDirs().containsKey(parsedPath.dir)) {
            abstractDirectory = this.getAbstractDirs().get(parsedPath.dir);
        } else {
            abstractDirectory = this.createDirLocal(parsedPath.dir);
            this.getAbstractDirs().put(parsedPath.dir, abstractDirectory);
        }
        return abstractDirectory.createDir(parsedPath.subpath);
    }

    @Override
    public boolean removeFile(String string) {
        SubPath subPath;
        try {
            subPath = this.getSubPath(string);
        }
        catch (PathNotExist pathNotExist) {
            return false;
        }
        if (subPath.dir != null) {
            return subPath.dir.removeFile(subPath.path);
        }
        if (!this.getFiles().contains(subPath.path)) {
            return false;
        }
        this.removeFileLocal(subPath.path);
        this.getFiles().remove(subPath.path);
        return true;
    }

    @Override
    public void copyToDir(Directory directory) throws DirectoryException {
        DirUtil.copyToDir(directory, directory);
    }

    @Override
    public void copyToDir(Directory directory, String[] stringArray) throws DirectoryException {
        DirUtil.copyToDir(directory, directory, stringArray);
    }

    @Override
    public void copyToDir(Directory directory, String string) throws DirectoryException {
        DirUtil.copyToDir(directory, directory, string);
    }

    @Override
    public void copyToDir(File file) throws DirectoryException {
        DirUtil.copyToDir((Directory)this, file);
    }

    @Override
    public void copyToDir(File file, String[] stringArray) throws DirectoryException {
        DirUtil.copyToDir((Directory)this, file, stringArray);
    }

    @Override
    public void copyToDir(File file, String string) throws DirectoryException {
        DirUtil.copyToDir((Directory)this, file, string);
    }

    protected Map<String, AbstractDirectory> getAbstractDirs() {
        return this.getAbstractDirs(false);
    }

    protected Map<String, AbstractDirectory> getAbstractDirs(boolean bl) {
        if (this.mDirs == null) {
            this.loadDirs();
        }
        if (!bl) {
            return this.mDirs;
        }
        LinkedHashMap<String, AbstractDirectory> linkedHashMap = new LinkedHashMap<String, AbstractDirectory>(this.mDirs);
        for (Map.Entry<String, AbstractDirectory> entry : this.getAbstractDirs().entrySet()) {
            for (Map.Entry<String, AbstractDirectory> entry2 : entry.getValue().getAbstractDirs(true).entrySet()) {
                linkedHashMap.put(entry.getKey() + '/' + entry2.getKey(), entry2.getValue());
            }
        }
        return linkedHashMap;
    }

    private SubPath getSubPath(String string) throws PathNotExist {
        ParsedPath parsedPath = this.parsePath(string);
        if (parsedPath.dir == null) {
            return new SubPath(null, parsedPath.subpath);
        }
        if (!this.getAbstractDirs().containsKey(parsedPath.dir)) {
            throw new PathNotExist(string);
        }
        return new SubPath(this.getAbstractDirs().get(parsedPath.dir), parsedPath.subpath);
    }

    private ParsedPath parsePath(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            return new ParsedPath(null, string);
        }
        return new ParsedPath(string.substring(0, n), string.substring(n + 1));
    }

    protected abstract void loadFiles();

    protected abstract void loadDirs();

    protected abstract InputStream getFileInputLocal(String var1) throws DirectoryException;

    protected abstract OutputStream getFileOutputLocal(String var1) throws DirectoryException;

    protected abstract AbstractDirectory createDirLocal(String var1) throws DirectoryException;

    protected abstract void removeFileLocal(String var1);

    private class SubPath {
        public AbstractDirectory dir;
        public String path;

        public SubPath(AbstractDirectory abstractDirectory2, String string) {
            this.dir = abstractDirectory2;
            this.path = string;
        }
    }

    private class ParsedPath {
        public String dir;
        public String subpath;

        public ParsedPath(String string, String string2) {
            this.dir = string;
            this.subpath = string2;
        }
    }
}

