/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.src.TypeName;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.Code.Analysis.RegisterType;

public class DebugInjector {
    private final ListIterator<String> mIt;
    private final StringBuilder mOut;
    private boolean mFirstInstruction = true;
    private final Set<String> mInitializedRegisters = new HashSet<String>();
    private static final Pattern REGISTER_INFO_PATTERN = Pattern.compile("((?:p|v)\\d+)=\\(([^)]+)\\);");

    public static void inject(ListIterator<String> listIterator, StringBuilder stringBuilder) throws AndrolibException {
        new DebugInjector(listIterator, stringBuilder).inject();
    }

    private DebugInjector(ListIterator<String> listIterator, StringBuilder stringBuilder) {
        this.mIt = listIterator;
        this.mOut = stringBuilder;
    }

    private void inject() throws AndrolibException {
        String string = this.nextAndAppend();
        if (string.contains(" abstract ") || string.contains(" native ")) {
            this.nextAndAppend();
            return;
        }
        this.injectParameters(string);
        boolean bl = false;
        while (!bl) {
            bl = this.step();
        }
    }

    private void injectParameters(String string) throws AndrolibException {
        int n;
        int n2 = string.indexOf(40);
        if (n2 == -1) {
            throw new AndrolibException();
        }
        int n3 = string.indexOf(41, n2);
        if (n3 == -1) {
            throw new AndrolibException();
        }
        String string2 = string.substring(n2 + 1, n3);
        int n4 = TypeName.listFromInternalName(string2).size() + n;
        for (n = string.contains(" static ") ? 0 : 1; n < n4; ++n) {
            this.mOut.append(".parameter \"p").append(n).append("\"\n");
        }
    }

    private boolean step() {
        String string = this.next();
        if (string.isEmpty()) {
            return false;
        }
        switch (string.charAt(0)) {
            case '#': {
                return this.processComment(string);
            }
            case ':': {
                this.append(string);
                return false;
            }
            case '.': {
                return this.processDirective(string);
            }
        }
        return this.processInstruction(string);
    }

    private boolean processComment(String string) {
        if (this.mFirstInstruction) {
            return false;
        }
        Matcher matcher = REGISTER_INFO_PATTERN.matcher(string);
        block12: while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = null;
            switch (RegisterType.Category.valueOf(matcher.group(2))) {
                case Reference: 
                case Null: 
                case UninitRef: 
                case UninitThis: {
                    string3 = "Ljava/lang/Object;";
                    break;
                }
                case Boolean: {
                    string3 = "Z";
                    break;
                }
                case Integer: 
                case One: 
                case Unknown: {
                    string3 = "I";
                    break;
                }
                case Uninit: 
                case Conflicted: {
                    if (!this.mInitializedRegisters.remove(string2)) continue block12;
                    this.mOut.append(".end local ").append(string2).append('\n');
                    continue block12;
                }
                case Short: 
                case PosShort: {
                    string3 = "S";
                    break;
                }
                case Byte: 
                case PosByte: {
                    string3 = "B";
                    break;
                }
                case Char: {
                    string3 = "C";
                    break;
                }
                case Float: {
                    string3 = "F";
                    break;
                }
                case LongHi: 
                case LongLo: {
                    string3 = "J";
                    break;
                }
                case DoubleHi: 
                case DoubleLo: {
                    string3 = "D";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.mInitializedRegisters.add(string2);
            this.mOut.append(".local ").append(string2).append(", ").append(string2).append(':').append(string3).append('\n');
        }
        return false;
    }

    private boolean processDirective(String string) {
        block3: {
            String string2 = string.substring(1);
            if (string2.startsWith("line ") || string2.equals("prologue") || string2.startsWith("parameter") || string2.startsWith("local ") || string2.startsWith("end local ")) {
                return false;
            }
            this.append(string);
            if (string2.equals("end method")) {
                return true;
            }
            if (!string2.startsWith("annotation ") && !string2.equals("sparse-switch") && !string2.startsWith("packed-switch ") && !string2.startsWith("array-data ")) break block3;
            while (!(string2 = this.nextAndAppend()).startsWith(".end ")) {
            }
        }
        return false;
    }

    private boolean processInstruction(String string) {
        if (this.mFirstInstruction) {
            this.mOut.append(".prologue\n");
            this.mFirstInstruction = false;
        }
        this.mOut.append(".line ").append(this.mIt.nextIndex()).append('\n').append(string).append('\n');
        return false;
    }

    private String next() {
        return this.mIt.next().trim();
    }

    private String nextAndAppend() {
        String string = this.next();
        this.append(string);
        return string;
    }

    private void append(String string) {
        this.mOut.append(string).append('\n');
    }
}

