/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.AndrolibResources;
import brut.util.ExtDataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringBlock {
    private int[] m_stringOffsets;
    private byte[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private boolean m_isUTF8;
    private static final CharsetDecoder UTF16LE_DECODER = Charset.forName("UTF-16LE").newDecoder();
    private static final CharsetDecoder UTF8_DECODER = Charset.forName("UTF-8").newDecoder();
    private static final Logger LOGGER = Logger.getLogger(StringBlock.class.getName());
    private static final int CHUNK_TYPE = 0x1C0001;
    private static final int UTF8_FLAG = 256;

    public static StringBlock read(ExtDataInput extDataInput) throws IOException {
        int n;
        extDataInput.skipCheckInt(0x1C0001);
        int n2 = extDataInput.readInt();
        int n3 = extDataInput.readInt();
        int n4 = extDataInput.readInt();
        int n5 = extDataInput.readInt();
        int n6 = extDataInput.readInt();
        int n7 = extDataInput.readInt();
        StringBlock stringBlock = new StringBlock();
        stringBlock.m_isUTF8 = (n5 & 0x100) != 0;
        stringBlock.m_stringOffsets = extDataInput.readIntArray(n3);
        if (n4 != 0) {
            stringBlock.m_styleOffsets = extDataInput.readIntArray(n4);
        }
        if ((n = (n7 == 0 ? n2 : n7) - n6) % 4 != 0) {
            throw new IOException("String data size is not multiple of 4 (" + n + ").");
        }
        stringBlock.m_strings = new byte[n];
        extDataInput.readFully(stringBlock.m_strings);
        if (n7 != 0) {
            n = n2 - n7;
            if (n % 4 != 0) {
                throw new IOException("Style data size is not multiple of 4 (" + n + ").");
            }
            stringBlock.m_styles = extDataInput.readIntArray(n / 4);
        }
        return stringBlock;
    }

    public int getCount() {
        return this.m_stringOffsets != null ? this.m_stringOffsets.length : 0;
    }

    public String getString(int n) {
        int n2;
        if (n < 0 || this.m_stringOffsets == null || n >= this.m_stringOffsets.length) {
            return null;
        }
        int n3 = this.m_stringOffsets[n];
        if (!this.m_isUTF8) {
            n2 = StringBlock.getShort(this.m_strings, n3) * 2;
            n3 += 2;
        } else {
            n3 += StringBlock.getVarint(this.m_strings, n3)[1];
            int[] nArray = StringBlock.getVarint(this.m_strings, n3);
            n3 += nArray[1];
            n2 = nArray[0];
        }
        return this.decodeString(n3, n2);
    }

    public CharSequence get(int n) {
        return this.getString(n);
    }

    public String getHTML(int n) {
        String string = this.getString(n);
        if (string == null) {
            return string;
        }
        int[] nArray = this.getStyle(n);
        if (nArray == null) {
            return AndrolibResources.escapeTextForResXml(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        int[] nArray2 = new int[nArray.length / 3];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5;
            int n6;
            int n7 = -1;
            for (n6 = 0; n6 != nArray.length; n6 += 3) {
                if (nArray[n6 + 1] == -1 || n7 != -1 && nArray[n7 + 1] <= nArray[n6 + 1]) continue;
                n7 = n6;
            }
            int n8 = n7 != -1 ? nArray[n7 + 1] : string.length();
            for (n6 = n3 - 1; n6 >= 0 && (n5 = nArray[(n4 = nArray2[n6]) + 2]) < n8; --n6) {
                if (n2 <= n5) {
                    stringBuilder.append(AndrolibResources.escapeCharsForResXml(string.substring(n2, n5 + 1)));
                    n2 = n5 + 1;
                }
                this.outputStyleTag(this.getString(nArray[n4]), stringBuilder, true);
            }
            n3 = n6 + 1;
            if (n2 < n8) {
                stringBuilder.append(AndrolibResources.escapeCharsForResXml(string.substring(n2, n8)));
                n2 = n8;
            }
            if (n7 == -1) break;
            this.outputStyleTag(this.getString(nArray[n7]), stringBuilder, false);
            nArray[n7 + 1] = -1;
            nArray2[n3++] = n7;
        }
        return AndrolibResources.escapeTextForResXml(stringBuilder.toString(), false);
    }

    private void outputStyleTag(String string, StringBuilder stringBuilder, boolean bl) {
        int n;
        stringBuilder.append('<');
        if (bl) {
            stringBuilder.append('/');
        }
        if ((n = string.indexOf(59)) == -1) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append(string.substring(0, n));
            if (!bl) {
                boolean bl2 = true;
                while (bl2) {
                    String string2;
                    int n2 = string.indexOf(61, n + 1);
                    stringBuilder.append(' ').append(string.substring(n + 1, n2)).append("=\"");
                    n = string.indexOf(59, n2 + 1);
                    if (n != -1) {
                        string2 = string.substring(n2 + 1, n);
                    } else {
                        bl2 = false;
                        string2 = string.substring(n2 + 1);
                    }
                    stringBuilder.append(AndrolibResources.escapeCharsForResXml(string2)).append('\"');
                }
            }
        }
        stringBuilder.append('>');
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i != this.m_stringOffsets.length; ++i) {
            int n;
            int n2 = this.m_stringOffsets[i];
            int n3 = StringBlock.getShort(this.m_strings, n2);
            if (n3 != string.length()) continue;
            for (n = 0; n != n3 && string.charAt(n) == StringBlock.getShort(this.m_strings, n2 += 2); ++n) {
            }
            if (n != n3) continue;
            return i;
        }
        return -1;
    }

    private StringBlock() {
    }

    private int[] getStyle(int n) {
        int n2;
        if (this.m_styleOffsets == null || this.m_styles == null || n >= this.m_styleOffsets.length) {
            return null;
        }
        int n3 = this.m_styleOffsets[n] / 4;
        int n4 = 0;
        for (n2 = n3; n2 < this.m_styles.length && this.m_styles[n2] != -1; ++n2) {
            ++n4;
        }
        if (n4 == 0 || n4 % 3 != 0) {
            return null;
        }
        int[] nArray = new int[n4];
        n4 = n3;
        n2 = 0;
        while (n4 < this.m_styles.length && this.m_styles[n4] != -1) {
            nArray[n2++] = this.m_styles[n4++];
        }
        return nArray;
    }

    private String decodeString(int n, int n2) {
        try {
            return (this.m_isUTF8 ? UTF8_DECODER : UTF16LE_DECODER).decode(ByteBuffer.wrap(this.m_strings, n, n2)).toString();
        }
        catch (CharacterCodingException characterCodingException) {
            LOGGER.log(Level.WARNING, null, characterCodingException);
            return null;
        }
    }

    private static final int getShort(byte[] byArray, int n) {
        return (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    private static final int getShort(int[] nArray, int n) {
        int n2 = nArray[n / 4];
        if (n % 4 / 2 == 0) {
            return n2 & 0xFFFF;
        }
        return n2 >>> 16;
    }

    private static final int[] getVarint(byte[] byArray, int n) {
        int n2 = byArray[n];
        boolean bl = (n2 & 0x80) != 0;
        n2 &= 0x7F;
        if (!bl) {
            return new int[]{n2, 1};
        }
        return new int[]{n2 << 8 | byArray[n + 1] & 0xFF, 2};
    }
}

