/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.err.CantFind9PatchChunk;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.util.ExtDataInput;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class Res9patchStreamDecoder
implements ResStreamDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    @Override
    public void decode(InputStream inputStream, OutputStream outputStream) throws AndrolibException {
        try {
            byte[] byArray = IOUtils.toByteArray(inputStream);
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            BufferedImage bufferedImage2 = new BufferedImage(n + 2, n2 + 2, 6);
            if (bufferedImage.getType() == 6) {
                bufferedImage2.getRaster().setRect(1, 1, bufferedImage.getRaster());
            } else {
                bufferedImage2.getGraphics().drawImage(bufferedImage, 1, 1, null);
            }
            NinePatch ninePatch = this.getNinePatch(byArray);
            this.drawHLine(bufferedImage2, n2 + 1, ninePatch.padLeft + 1, n - ninePatch.padRight);
            this.drawVLine(bufferedImage2, n + 1, ninePatch.padTop + 1, n2 - ninePatch.padBottom);
            int[] nArray = ninePatch.xDivs;
            for (int i = 0; i < nArray.length; i += 2) {
                this.drawHLine(bufferedImage2, 0, nArray[i] + 1, nArray[i + 1]);
            }
            int[] nArray2 = ninePatch.yDivs;
            for (int i = 0; i < nArray2.length; i += 2) {
                this.drawVLine(bufferedImage2, 0, nArray2[i] + 1, nArray2[i + 1]);
            }
            ImageIO.write((RenderedImage)bufferedImage2, "png", outputStream);
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
    }

    private NinePatch getNinePatch(byte[] byArray) throws AndrolibException, IOException {
        ExtDataInput extDataInput = new ExtDataInput(new ByteArrayInputStream(byArray));
        this.find9patchChunk(extDataInput);
        return NinePatch.decode(extDataInput);
    }

    private void find9patchChunk(DataInput dataInput) throws AndrolibException, IOException {
        dataInput.skipBytes(8);
        while (true) {
            int n;
            try {
                n = dataInput.readInt();
            }
            catch (IOException iOException) {
                throw new CantFind9PatchChunk("Cant find nine patch chunk", iOException);
            }
            if (dataInput.readInt() == 1852855395) {
                return;
            }
            dataInput.skipBytes(n + 4);
        }
    }

    private void drawHLine(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            bufferedImage.setRGB(i, n, -16777216);
        }
    }

    private void drawVLine(BufferedImage bufferedImage, int n, int n2, int n3) {
        for (int i = n2; i <= n3; ++i) {
            bufferedImage.setRGB(n, i, -16777216);
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
            this.padLeft = n;
            this.padRight = n2;
            this.padTop = n3;
            this.padBottom = n4;
            this.xDivs = nArray;
            this.yDivs = nArray2;
        }

        public static NinePatch decode(ExtDataInput extDataInput) throws IOException {
            extDataInput.skipBytes(1);
            byte by = extDataInput.readByte();
            byte by2 = extDataInput.readByte();
            extDataInput.skipBytes(1);
            extDataInput.skipBytes(8);
            int n = extDataInput.readInt();
            int n2 = extDataInput.readInt();
            int n3 = extDataInput.readInt();
            int n4 = extDataInput.readInt();
            extDataInput.skipBytes(4);
            int[] nArray = extDataInput.readIntArray(by);
            int[] nArray2 = extDataInput.readIntArray(by2);
            return new NinePatch(n, n2, n3, n4, nArray, nArray2);
        }
    }
}

